// caretsView.cpp : implementation of the CCaretsView class
//

#include "stdafx.h"
#include "carets.h"

#include "caretsDoc.h"
#include "caretsView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCaretsView

IMPLEMENT_DYNCREATE(CCaretsView, CView)

BEGIN_MESSAGE_MAP(CCaretsView, CView)
	//{{AFX_MSG_MAP(CCaretsView)
	ON_WM_CHAR()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCaretsView construction/destruction

CCaretsView::CCaretsView()
{
	CaretCreated = false;
	// TODO: add construction code here

}

CCaretsView::~CCaretsView()
{
}

BOOL CCaretsView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCaretsView drawing

void CCaretsView::OnDraw(CDC* pDC)
{
	CCaretsDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if(!CaretCreated){
		TEXTMETRIC textmetric;

		pDC->GetTextMetrics(&textmetric);

		CreateSolidCaret(textmetric.tmAveCharWidth/8, textmetric.tmHeight);
		CaretPosition.x = CaretPosition.y = 0;

		SetCaretPos(CaretPosition);
		ShowCaret();
		CaretCreated = true;
	}

	pDC->TextOut(0, 0, pDoc->StringData);

	CSize size = pDC->GetTextExtent(pDoc->StringData);

	HideCaret();

	CaretPosition.x = size.cx;
	SetCaretPos(CaretPosition);

	ShowCaret();

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CCaretsView printing

BOOL CCaretsView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCaretsView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCaretsView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CCaretsView diagnostics

#ifdef _DEBUG
void CCaretsView::AssertValid() const
{
	CView::AssertValid();
}

void CCaretsView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCaretsDoc* CCaretsView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCaretsDoc)));
	return (CCaretsDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCaretsView message handlers

void CCaretsView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CCaretsDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->StringData += nChar;
	Invalidate();

	CView::OnChar(nChar, nRepCnt, nFlags);
}

void CCaretsView::OnKillFocus(CWnd* pNewWnd) 
{
	CView::OnKillFocus(pNewWnd);
	HideCaret();
	
	// TODO: Add your message handler code here
	
}

void CCaretsView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);
	ShowCaret();

	// TODO: Add your message handler code here
	
}
