// BoxerCtl.cpp : Implementation of the CBoxerCtrl ActiveX Control class.

#include "stdafx.h"
#include "boxer.h"
#include "BoxerCtl.h"
#include "BoxerPpg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CBoxerCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CBoxerCtrl, COleControl)
	//{{AFX_MSG_MAP(CBoxerCtrl)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CBoxerCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CBoxerCtrl)
	// NOTE - ClassWizard will add and remove dispatch map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CBoxerCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CBoxerCtrl, COleControl)
	//{{AFX_EVENT_MAP(CBoxerCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CBoxerCtrl, 1)
	PROPPAGEID(CBoxerPropPage::guid)
END_PROPPAGEIDS(CBoxerCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CBoxerCtrl, "BOXER.BoxerCtrl.1",
	0x6e67e887, 0x5516, 0x11d1, 0xa3, 0x4b, 0, 0xa0, 0x24, 0x7, 0x52, 0xcb)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CBoxerCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DBoxer =
		{ 0x6e67e885, 0x5516, 0x11d1, { 0xa3, 0x4b, 0, 0xa0, 0x24, 0x7, 0x52, 0xcb } };
const IID BASED_CODE IID_DBoxerEvents =
		{ 0x6e67e886, 0x5516, 0x11d1, { 0xa3, 0x4b, 0, 0xa0, 0x24, 0x7, 0x52, 0xcb } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwBoxerOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CBoxerCtrl, IDS_BOXER, _dwBoxerOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::CBoxerCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CBoxerCtrl

BOOL CBoxerCtrl::CBoxerCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_BOXER,
			IDB_BOXER,
			afxRegApartmentThreading,
			_dwBoxerOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::CBoxerCtrl - Constructor

CBoxerCtrl::CBoxerCtrl()
{
	InitializeIIDs(&IID_DBoxer, &IID_DBoxerEvents);
	
	fill1 = fill2 = fill3 = fill4 = false;
	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::~CBoxerCtrl - Destructor

CBoxerCtrl::~CBoxerCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::OnDraw - Drawing function

void CBoxerCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));

	box1 = CRect(rcBounds.left, rcBounds.top, rcBounds.right/2, rcBounds.bottom/2);
	box2 = CRect(rcBounds.left, rcBounds.bottom/2, rcBounds.right/2, rcBounds.bottom);
	box3 = CRect(rcBounds.right/2, rcBounds.top, rcBounds.right, rcBounds.bottom/2);
	box4 = CRect(rcBounds.right/2, rcBounds.bottom/2, rcBounds.right, rcBounds.bottom);

	pdc->Rectangle(&box1);
	pdc->Rectangle(&box2);
	pdc->Rectangle(&box3);
	pdc->Rectangle(&box4);

	if(fill1) pdc->FillSolidRect(&box1, RGB(0, 0, 0));
	if(fill2) pdc->FillSolidRect(&box2, RGB(0, 0, 0));
	if(fill3) pdc->FillSolidRect(&box3, RGB(0, 0, 0));
	if(fill4) pdc->FillSolidRect(&box4, RGB(0, 0, 0));
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::DoPropExchange - Persistence support

void CBoxerCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::OnResetState - Reset control to default state

void CBoxerCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl::AboutBox - Display an "About" box to the user

void CBoxerCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_BOXER);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CBoxerCtrl message handlers

void CBoxerCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	fill1 =	box1.PtInRect(point);
	fill2 =	box2.PtInRect(point);
	fill3 =	box3.PtInRect(point);
	fill4 =	box4.PtInRect(point);
	Invalidate();

	COleControl::OnLButtonDown(nFlags, point);
}
