// writerView.cpp : implementation of the CWriterView class
//

#include "stdafx.h"
#include "writer.h"

#include "writerDoc.h"
#include "writerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWriterView

IMPLEMENT_DYNCREATE(CWriterView, CView)

BEGIN_MESSAGE_MAP(CWriterView, CView)
	//{{AFX_MSG_MAP(CWriterView)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWriterView construction/destruction

CWriterView::CWriterView()
{
	// TODO: add construction code here

}

CWriterView::~CWriterView()
{
}

BOOL CWriterView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWriterView drawing

void CWriterView::OnDraw(CDC* pDC)
{
	CWriterDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDC->TextOut(0, 0, pDoc->StringData);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CWriterView printing

BOOL CWriterView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CWriterView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CWriterView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CWriterView diagnostics

#ifdef _DEBUG
void CWriterView::AssertValid() const
{
	CView::AssertValid();
}

void CWriterView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWriterDoc* CWriterView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWriterDoc)));
	return (CWriterDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWriterView message handlers

void CWriterView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CWriterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->StringData += nChar;
	Invalidate();
	pDoc->SetModifiedFlag();

	CView::OnChar(nChar, nRepCnt, nFlags);
}
