// mouserView.cpp : implementation of the CMouserView class
//

#include "stdafx.h"
#include "mouser.h"

#include "mouserDoc.h"
#include "mouserView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMouserView

IMPLEMENT_DYNCREATE(CMouserView, CView)

BEGIN_MESSAGE_MAP(CMouserView, CView)
	//{{AFX_MSG_MAP(CMouserView)
	ON_WM_CHAR()
	ON_WM_LBUTTONDOWN()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMouserView construction/destruction

CMouserView::CMouserView()
{
	// TODO: add construction code here
	CaretCreated = false;
	x = y = 0;
}

CMouserView::~CMouserView()
{
}

BOOL CMouserView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMouserView drawing

void CMouserView::OnDraw(CDC* pDC)
{
	CMouserDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if(!CaretCreated){
		TEXTMETRIC textmetric;

		pDC->GetTextMetrics(&textmetric);

		CreateSolidCaret(textmetric.tmAveCharWidth/8, textmetric.tmHeight);
		CaretPosition.x = CaretPosition.y = 0;

		SetCaretPos(CaretPosition);
		ShowCaret();
		CaretCreated = true;
	}

	pDC->TextOut(x, y, pDoc->StringData);

	CSize size = pDC->GetTextExtent(pDoc->StringData);

	HideCaret();

	CaretPosition.x = x + size.cx;
	CaretPosition.y = y;
	SetCaretPos(CaretPosition);

	ShowCaret();

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CMouserView printing

BOOL CMouserView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMouserView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMouserView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMouserView diagnostics

#ifdef _DEBUG
void CMouserView::AssertValid() const
{
	CView::AssertValid();
}

void CMouserView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMouserDoc* CMouserView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMouserDoc)));
	return (CMouserDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMouserView message handlers

void CMouserView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CMouserDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->StringData += nChar;
	Invalidate();

	CView::OnChar(nChar, nRepCnt, nFlags);
}

void CMouserView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	x = point.x;
	y = point.y;

	CMouserDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->StringData.Empty();

	Invalidate();

	CView::OnLButtonDown(nFlags, point);
}

void CMouserView::OnKillFocus(CWnd* pNewWnd) 
{
	CView::OnKillFocus(pNewWnd);
	HideCaret();

	// TODO: Add your message handler code here
	
}

void CMouserView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);
	ShowCaret();

	// TODO: Add your message handler code here
	
}
