// painterView.cpp : implementation of the CPainterView class
//

#include "stdafx.h"
#include "painter.h"

#include "painterDoc.h"
#include "painterView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPainterView

IMPLEMENT_DYNCREATE(CPainterView, CView)

BEGIN_MESSAGE_MAP(CPainterView, CView)
	//{{AFX_MSG_MAP(CPainterView)
	ON_COMMAND(ID_TOOLS_FREEHAND, OnToolsFreehand)
	ON_COMMAND(ID_TOOLS_LINE, OnToolsLine)
	ON_COMMAND(ID_TOOLS_RECTANGLE, OnToolsRectangle)
	ON_COMMAND(ID_TOOLS_ELLIPSE, OnToolsEllipse)
	ON_COMMAND(ID_TOOLS_FILL, OnToolsFill)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ELLIPSE, OnUpdateToolsEllipse)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_FILL, OnUpdateToolsFill)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_FREEHAND, OnUpdateToolsFreehand)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_LINE, OnUpdateToolsLine)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_RECTANGLE, OnUpdateToolsRectangle)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPainterView construction/destruction

CPainterView::CPainterView()
{
	// TODO: add construction code here
	MakeAllFlagsFalse();
}

CPainterView::~CPainterView()
{
}

BOOL CPainterView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	cs.lpszClass = AfxRegisterWndClass(CS_DBLCLKS, AfxGetApp()->LoadStandardCursor(IDC_CROSS), (HBRUSH)(COLOR_WINDOW+1), AfxGetApp()->LoadIcon(IDR_MAINFRAME));
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CPainterView drawing

void CPainterView::OnDraw(CDC* pDC)
{
	CPainterDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	HMETAFILE MetaFileHandle = pDoc->pMetaFileDC->Close();
	pDC->PlayMetaFile(MetaFileHandle);
	CMetaFileDC *pNewMetaFile = new CMetaFileDC();
	pNewMetaFile->Create();
	pNewMetaFile->PlayMetaFile(MetaFileHandle);
	DeleteMetaFile(MetaFileHandle);
	delete pDoc->pMetaFileDC;
	pDoc->pMetaFileDC = pNewMetaFile;
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CPainterView printing

BOOL CPainterView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPainterView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPainterView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CPainterView diagnostics

#ifdef _DEBUG
void CPainterView::AssertValid() const
{
	CView::AssertValid();
}

void CPainterView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPainterDoc* CPainterView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPainterDoc)));
	return (CPainterDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPainterView message handlers

void CPainterView::MakeAllFlagsFalse()
{
	bDrawFlag = false;
	bLineFlag = false;
	bRectangleFlag = false;
	bEllipseFlag = false;
	bFillFlag = false;
}


	

void CPainterView::OnToolsFreehand() 
{
	// TODO: Add your command handler code here
	MakeAllFlagsFalse();
	bDrawFlag = true;
}

void CPainterView::OnToolsLine() 
{
	// TODO: Add your command handler code here
	MakeAllFlagsFalse();
	bLineFlag = true;	
}

void CPainterView::OnToolsRectangle() 
{
	// TODO: Add your command handler code here
	MakeAllFlagsFalse();
	bRectangleFlag = true;	
}

void CPainterView::OnToolsEllipse() 
{
	// TODO: Add your command handler code here
	MakeAllFlagsFalse();
	bEllipseFlag = true;	
}

void CPainterView::OnToolsFill() 
{
	// TODO: Add your command handler code here
	MakeAllFlagsFalse();
	bFillFlag = true;	
}


void CPainterView::OnUpdateToolsEllipse(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(bEllipseFlag);	
}

void CPainterView::OnUpdateToolsFill(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(bFillFlag);	
}

void CPainterView::OnUpdateToolsFreehand(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(bDrawFlag);	
}

void CPainterView::OnUpdateToolsLine(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(bLineFlag);	
}

void CPainterView::OnUpdateToolsRectangle(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(bRectangleFlag);	
}

void CPainterView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	Anchor = point;	
	OldPoint = point;

	CView::OnLButtonDown(nFlags, point);
}

void CPainterView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CPainterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	DrawTo = point;

	CClientDC *pDC = new CClientDC(this);

	if(bLineFlag){
		pDC->MoveTo(Anchor);
		pDC->LineTo(DrawTo);
		pDoc->pMetaFileDC->MoveTo(Anchor);
		pDoc->pMetaFileDC->LineTo(DrawTo);
	}

	if(bRectangleFlag){
		pDC->SelectStockObject(NULL_BRUSH);
		pDC->Rectangle(Anchor.x, Anchor.y, DrawTo.x, DrawTo.y);
		pDoc->pMetaFileDC->SelectStockObject(NULL_BRUSH);
		pDoc->pMetaFileDC->Rectangle(Anchor.x, Anchor.y, DrawTo.x, DrawTo.y);
	}

	if(bEllipseFlag){
		pDC->SelectStockObject(NULL_BRUSH);
		pDC->Ellipse(Anchor.x, Anchor.y, DrawTo.x, DrawTo.y);
		pDoc->pMetaFileDC->SelectStockObject(NULL_BRUSH);
		pDoc->pMetaFileDC->Ellipse(Anchor.x, Anchor.y, DrawTo.x, DrawTo.y);
	}

	if(bFillFlag){
		pDC->SelectStockObject(BLACK_BRUSH);
		pDC->FloodFill(Anchor.x, Anchor.y, RGB(0, 0, 0));
		pDoc->pMetaFileDC->SelectStockObject(BLACK_BRUSH);
		pDoc->pMetaFileDC->FloodFill(Anchor.x, Anchor.y, RGB(0, 0, 0));
	}

	delete pDC;

	CView::OnLButtonUp(nFlags, point);
}

void CPainterView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	int nOldMode;

	CClientDC *pDC = new CClientDC(this);
	CPainterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if((nFlags && MK_LBUTTON) && bDrawFlag){
		pDC->MoveTo(Anchor);
		pDC->LineTo(point);
		pDoc->pMetaFileDC->MoveTo(Anchor);
		pDoc->pMetaFileDC->LineTo(point);
		Anchor = point;
	}

	if((nFlags && MK_LBUTTON) && bLineFlag){
		nOldMode = pDC->GetROP2();
		pDC->SetROP2(R2_NOT);
		pDC->MoveTo(Anchor);
		pDC->LineTo(OldPoint);

		pDC->MoveTo(Anchor);
		pDC->LineTo(point);
		pDC->SetROP2(nOldMode);

		nOldMode = pDC->GetROP2();
		pDoc->pMetaFileDC->SetROP2(R2_NOT);
		pDoc->pMetaFileDC->MoveTo(Anchor);
		pDoc->pMetaFileDC->LineTo(OldPoint);

		pDoc->pMetaFileDC->MoveTo(Anchor);
		pDoc->pMetaFileDC->LineTo(point);
		pDoc->pMetaFileDC->SetROP2(nOldMode);

		OldPoint = point;
	}

	if((nFlags && MK_LBUTTON) && bRectangleFlag){
		nOldMode = pDC->GetROP2();
		pDC->SetROP2(R2_NOT);
		pDC->SelectStockObject(NULL_BRUSH);
		pDC->Rectangle(Anchor.x, Anchor.y, OldPoint.x, OldPoint.y);
		pDC->Rectangle(Anchor.x, Anchor.y, point.x, point.y);
		pDC->SetROP2(nOldMode);

		nOldMode = pDC->GetROP2();
		pDoc->pMetaFileDC->SetROP2(R2_NOT);
		pDoc->pMetaFileDC->SelectStockObject(NULL_BRUSH);
		pDoc->pMetaFileDC->Rectangle(Anchor.x, Anchor.y, OldPoint.x, OldPoint.y);
		pDoc->pMetaFileDC->Rectangle(Anchor.x, Anchor.y, point.x, point.y);
		pDoc->pMetaFileDC->SetROP2(nOldMode);

		OldPoint = point;
	}

	if((nFlags && MK_LBUTTON) && bEllipseFlag){
		nOldMode = pDC->GetROP2();
		pDC->SetROP2(R2_NOT);
		pDC->SelectStockObject(NULL_BRUSH);
		pDC->Ellipse(Anchor.x, Anchor.y, OldPoint.x, OldPoint.y);
		pDC->Ellipse(Anchor.x, Anchor.y, point.x, point.y);
		pDC->SetROP2(nOldMode);

		nOldMode = pDC->GetROP2();
		pDoc->pMetaFileDC->SetROP2(R2_NOT);
		pDoc->pMetaFileDC->SelectStockObject(NULL_BRUSH);
		pDoc->pMetaFileDC->Ellipse(Anchor.x, Anchor.y, OldPoint.x, OldPoint.y);
		pDoc->pMetaFileDC->Ellipse(Anchor.x, Anchor.y, point.x, point.y);
		pDoc->pMetaFileDC->SetROP2(nOldMode);

		OldPoint = point;
	}

	delete pDC;
	
	CView::OnMouseMove(nFlags, point);
}


void CPainterView::OnFileNew() 
{
	// TODO: Add your command handler code here
	CPainterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CMetaFileDC *pNewMetaFile = new CMetaFileDC();
	pNewMetaFile->Create();
	delete pDoc->pMetaFileDC;
	pDoc->pMetaFileDC = pNewMetaFile;

	Invalidate();
}

void CPainterView::OnFileOpen() 
{
	// TODO: Add your command handler code here
	CPainterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	HMETAFILE MetaFileHandle = GetMetaFile("painter.wmf");

	CMetaFileDC *pNewMetaFile = new CMetaFileDC();
	pNewMetaFile->Create();
	pNewMetaFile->PlayMetaFile(MetaFileHandle);
	DeleteMetaFile(MetaFileHandle);
	delete pDoc->pMetaFileDC;
	pDoc->pMetaFileDC = pNewMetaFile;

	Invalidate();
}

void CPainterView::OnFileSave() 
{
	// TODO: Add your command handler code here
	CPainterDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	HMETAFILE MetaFileHandle = pDoc->pMetaFileDC->Close();
	CopyMetaFile(MetaFileHandle, "painter.wmf");

	CMetaFileDC *pNewMetaFile = new CMetaFileDC();
	pNewMetaFile->Create();
	pNewMetaFile->PlayMetaFile(MetaFileHandle);
	DeleteMetaFile(MetaFileHandle);
	delete pDoc->pMetaFileDC;
	pDoc->pMetaFileDC = pNewMetaFile;
}
