// painterView.h : interface of the CPainterView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_PAINTERVIEW_H__F0E718AE_43DF_11D1_A34B_00A0240752CB__INCLUDED_)
#define AFX_PAINTERVIEW_H__F0E718AE_43DF_11D1_A34B_00A0240752CB__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CPainterView : public CView
{
protected: // create from serialization only
	CPainterView();
	DECLARE_DYNCREATE(CPainterView)

// Attributes
public:
	CPainterDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPainterView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPainterView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CPoint Anchor;
	CPoint DrawTo;
	CPoint OldPoint;
	boolean bDrawFlag;
	boolean bLineFlag;
	boolean bRectangleFlag;
	boolean bEllipseFlag;
	boolean bFillFlag;
	void MakeAllFlagsFalse();

// Generated message map functions
protected:
	//{{AFX_MSG(CPainterView)
	afx_msg void OnToolsFreehand();
	afx_msg void OnToolsLine();
	afx_msg void OnToolsRectangle();
	afx_msg void OnToolsEllipse();
	afx_msg void OnToolsFill();
	afx_msg void OnUpdateToolsEllipse(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsFill(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsFreehand(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsLine(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsRectangle(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnFileNew();
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in painterView.cpp
inline CPainterDoc* CPainterView::GetDocument()
   { return (CPainterDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PAINTERVIEW_H__F0E718AE_43DF_11D1_A34B_00A0240752CB__INCLUDED_)
