// scrollerView.cpp : implementation of the CScrollerView class
//

#include "stdafx.h"
#include "scroller.h"

#include "scrollerDoc.h"
#include "scrollerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScrollerView

IMPLEMENT_DYNCREATE(CScrollerView, CScrollView)

BEGIN_MESSAGE_MAP(CScrollerView, CScrollView)
	//{{AFX_MSG_MAP(CScrollerView)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScrollerView construction/destruction

CScrollerView::CScrollerView()
{
	// TODO: add construction code here

}

CScrollerView::~CScrollerView()
{
}

BOOL CScrollerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CScrollerView drawing

void CScrollerView::OnDraw(CDC* pDC)
{
	CScrollerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDC->TextOut(0, 0, pDoc->StringData);
	// TODO: add draw code for native data here
}

void CScrollerView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();
	CSize sizeTotal;
	// TODO: calculate the total size of this view

	CScrollerDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	sizeTotal.cx = pDoc->GetDocSize().cx;
	sizeTotal.cy = pDoc->GetDocSize().cy;

	SetScrollSizes(MM_TEXT, sizeTotal);
}

/////////////////////////////////////////////////////////////////////////////
// CScrollerView printing

BOOL CScrollerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CScrollerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CScrollerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CScrollerView diagnostics

#ifdef _DEBUG
void CScrollerView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CScrollerView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CScrollerDoc* CScrollerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CScrollerDoc)));
	return (CScrollerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScrollerView message handlers

void CScrollerView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CScrollerDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->StringData += nChar;
	Invalidate();

	pDoc->UpdateAllViews(this, 0L, NULL);
	pDoc->SetModifiedFlag();

	CScrollView::OnChar(nChar, nRepCnt, nFlags);
}
