﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml.XPath;

namespace XPathDocumentTester
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}

		private void btnFind_Click(object sender, EventArgs e)
		{
			int numAuthors = 0;
			string authorName = string.Empty;


			System.Xml.XPath.XPathDocument document = new XPathDocument("..\\..\\BookList.xml");
			XPathNavigator navigator = document.CreateNavigator();


			// wyrażenie filtra selekcji
			string selectionCriteria = "//Author[../BookName='" + txtBookName.Text + "']";

			XPathExpression query = navigator.Compile(selectionCriteria);

			// wybranie elementów pasujących do wyrażenia selekcji
			XPathNodeIterator nodes = navigator.Select(query);

			while (nodes.MoveNext())
			{
				if (++numAuthors > 1)    // lista autorów
				{
					authorName += ", ";
				}
				authorName += nodes.Current.Value;
			}

			if (numAuthors == 0)
			{
				authorName = "Nie znaleziono";
			}
			lblAuthor.Text = authorName;
		}
	}
}

