﻿using System;

namespace GenericLinkedList
{
	public class Pilgrim
	{
		private string name;
		public Pilgrim(string name)
		{
			this.name = name;
		}
		public override string ToString()
		{
			return this.name;
		}
	}
	public class Node<T>
	{
		// pola składowych
		private T data;
		private Node<T> next = null;

		// konstruktor
		public Node(T data)
		{
			this.data = data;
		}

		// właściwości
		public T Data { get { return this.data; } }

		public Node<T> Next
		{
			get { return this.next; }
		}

		// metody
		public void Append(Node<T> newNode)
		{
			if (this.next == null)
			{
				this.next = newNode;
			}
			else
			{
				next.Append(newNode);
			}
		}
		public override string ToString()
		{
			string output = data.ToString();

			if (next != null)
			{
				output += ", " + next.ToString();
			}

			return output;
		}
	}      // end class


	public class LinkedList<T>
	{
		// pola składowych
		private Node<T> headNode = null;

		// właściwości

		// indekser
		public T this[int index]
		{
			get
			{
				int ctr = 0;
				Node<T> node = headNode;

				while (node != null && ctr <= index)
				{
					if (ctr == index)
					{
						return node.Data;
					}
					else
					{
						node = node.Next;
					}

					++ctr;
				} // koniec while
				throw new ArgumentOutOfRangeException();
			}      // koniec get
		}          // koniec indeksera


		// konstruktor
		public LinkedList()
		{
		}

		// metody
		public void Add(T data)
		{
			if (headNode == null)
			{
				headNode = new Node<T>(data);
			}
			else
			{
				headNode.Append(new Node<T>(data));
			}
		}
		public override string ToString()
		{
			if (this.headNode != null)
			{
				return this.headNode.ToString();
			}
			else
			{
				return string.Empty;
			}
		}
	}

	class Program
	{
		static void Main(string[] args)
		{
			LinkedList<int> myLinkedList = new LinkedList<int>();
			for (int i = 0; i < 10; i++)
			{
				myLinkedList.Add(i);
			}


			Console.WriteLine("Integers: " + myLinkedList);
			LinkedList<Pilgrim> pilgrims = new LinkedList<Pilgrim>();
			pilgrims.Add(new Pilgrim("Rycerz"));
			pilgrims.Add(new Pilgrim("Młynarz"));
			pilgrims.Add(new Pilgrim("Szeryf"));
			pilgrims.Add(new Pilgrim("Kucharz"));

			Console.WriteLine("Pielgrzymi: " + pilgrims);
			Console.WriteLine("Czwarta liczba to " + myLinkedList[3]);
			Pilgrim d = pilgrims[1];
			Console.WriteLine("Drugi pielgrzym to " + d);
		}
	}
}
