﻿using System;
using System.Collections.Generic;

namespace CreateATypeSafeList
{
	// klasa obiektów przechowywanych na liście
	public class Employee
	{
		private int empID;

		// konstruktor
		public Employee(int empID)
		{
			this.empID = empID;
		}

		// przesłonięcie metody ToString tak, 
		// aby wyświetlała identyfikator obiektu
		public override string ToString()
		{
			return empID.ToString();
		}
	}		// koniec klasy

	// klasa testująca
	public class Program
	{
		// punkt wejściowy
		static void Main()
		{
			// Deklaracja listy typowanej (obiektów typu Employee)
			List<Employee> empList = new List<Employee>();

			// Deklaracja drugiej listy typowanej (wartości całkowitych)
			List<int> intList = new List<int>();

			// wypełnienie list
			for (int i = 0; i < 5; i++)
			{
				empList.Add(new Employee(i + 100));
				intList.Add(i * 5);
				// empList.Add(i * 5);  // patrz punkt "A co..."
			}

			// wypisanie elementów listy wartości całkowitych
			foreach (int i in intList)
			{
				Console.Write("{0} ", i.ToString());
			}

			Console.WriteLine("\n");

			// wypisanie identyfikatorów obiektów Employee
			foreach (Employee employee in empList)
			{
				Console.Write("{0} ", employee.ToString());
			}

			Console.WriteLine("\n");
		}
	}
}

