﻿using System;
using System.Collections;
using System.Data.SqlClient;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace DataStats
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}

		private void ModifyEachRow(DataSet ds)
		{
			foreach (DataRow row in ds.Tables["Orders"].Rows)
			{
				row["OrderDate"] = DateTime.Now;
			}
		}

		private void ShowStatistics(SqlConnection conn, ListBox lbox)
		{
			IDictionary dict = conn.RetrieveStatistics();
			foreach (string key in dict.Keys)
			{
				lbox.Items.Add(key + " = " + dict[key].ToString());
			}
		}

		private void button1_Click(object sender, EventArgs e)
		{
			string connString = "Data Source=LAPTOP\\SQLSERVER;Initial Catalog=Northwind;Integrated Security=SSPI";
			SqlConnection conn = new SqlConnection(connString);
			conn.StatisticsEnabled = true;
			conn.Open();
			SqlCommand cmd = new SqlCommand();
			cmd.Connection = conn;

			cmd.CommandText = "Select * from Orders";
			SqlDataAdapter dataAdapter = new SqlDataAdapter(cmd);
			SqlCommandBuilder bldr = new SqlCommandBuilder(dataAdapter);
			DataSet dataset = new DataSet();

			dataAdapter.Fill(dataset, "Orders");     // utworzenie tabeli zamówień
			ModifyEachRow(dataset);
			conn.ResetStatistics();    // wyzerowanie statystyk połączenia
			dataAdapter.Update(dataset, "Orders");   // aktualizacja bazy danych
			ShowStatistics(conn, this.lbNoBatch);
			dataAdapter.UpdateBatchSize = 10;
			ModifyEachRow(dataset);
			conn.ResetStatistics();
			dataAdapter.Update(dataset, "Orders");   // aktualizacja bazy danych
			ShowStatistics(conn, this.lbBatch);

			conn.Close();
		}
	}
}