﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ProfileInfo_aspx : System.Web.UI.Page
{
    // Page events are wired up automatically to methods 
    // with the following names:
    // Page_Load, Page_AbortTransaction, Page_CommitTransaction,
    // Page_DataBinding, Page_Disposed, Page_Error, Page_Init, 
    // Page_Init Complete, Page_Load, Page_LoadComplete, Page_PreInit
    // Page_PreLoad, Page_PreRender, Page_PreRenderComplete, 
    // Page_SaveStateComplete, Page_Unload
     
    protected void Page_Load(object sender, EventArgs e)
    {
		if (!IsPostBack && Profile.UserName != null)
		{
			if (Profile.IsAnonymous == false)
			{
				this.lastName.Text = Profile.lastName;
				this.firstName.Text = Profile.firstName;
				this.phoneNumber.Text = Profile.phoneNumber;
				this.birthDate.Text = Profile.birthDate.ToShortDateString();
			}

			if (Profile.CHOSENBOOKS != null)
			{
				foreach (ListItem li in this.cblBooks.Items)
				{
					foreach (string s in Profile.CHOSENBOOKS)
					{
						if (li.Text == s)
						{
							li.Selected = true;
						}   // koniec if
					}   // koniec pętli przeglądającej ciągi wybranych książek
				}   // koniec pętli przeglądającej elementy listy
			}   // koniec warunku obecności kolekcji książek
		}   // koniec warunku PostBack
	}   // koniec metody Page_Load



	protected void save_Click(object sender, EventArgs e)
	{
		if (Profile.IsAnonymous == false)
		{
			Profile.lastName = this.lastName.Text;
			Profile.firstName = this.firstName.Text;
			Profile.phoneNumber = this.phoneNumber.Text;
			Profile.birthDate = Convert.ToDateTime(this.birthDate.Text);
		}

		Profile.CHOSENBOOKS = new System.Collections.Specialized.StringCollection();
		foreach (ListItem item in this.cblBooks.Items)
		{
			if (item.Selected)
			{
				Profile.CHOSENBOOKS.Add(item.Value.ToString());
			}
		}
		Response.Redirect("Default.aspx");
	}
	protected void Set_Theme(object sender, EventArgs e)
	{
		Button btn = sender as Button;
		if (btn.Text == "Psychedelic")
		{
			Profile.Theme = "Psychedelic";
		}
		else
		{
			Profile.Theme = "Dark Blue";
		}
	}
}
