﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml.XPath;

namespace XPathDocumentTester
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
		}

		private void btnFind_Click(object sender, EventArgs e)
		{
			int numAuthors = 0;
			string authorName = string.Empty;

			// wczytanie pliku XML do XPathDocument
			XPathDocument document = new XPathDocument("..\\..\\BookList.xml");

			// inicjalizacja obiektu nawigacji po dokumencie
			XPathNavigator navigator = document.CreateNavigator();

			navigator.MoveToFirstChild();     // przejście do elementu books
			navigator.MoveToFirstChild();     // przejście do elementu book

			do                 // przegląd elementów osadzonych w book
			{
				// przejście do elementów wewnętrznych book
				navigator.MoveToFirstChild();

				do
				{
					// jeśli uda się dopasować tytuł ksiażki, wyszukiwanie można uznać za zakończone
					if (navigator.Value == txtBookName.Text)
					{
						do
						{    // przeglądanie tytułu książki, autorów, wydawcy
							if (navigator.Name == "Author")
							{
								if (++numAuthors > 1)    // tworzenie listy autorów, jeśli jest ich wielu
								{
									authorName += ", ";
								}
								authorName += navigator.Value;
							}
						} while (navigator.MoveToNext());
					}	// udało się znaleźć książkę
				} while (navigator.MoveToNext());    // koniec obsługi elementu wewnętrznego
				navigator.MoveToParent();            // ten element przejrzany, wyjście do elementu nadrzędnego
			} while (navigator.MoveToNext());        // następna książka
			if (numAuthors == 0)
			{
				authorName = "Nie znaleziono";
			}
			lblAuthor.Text = authorName;
		}
	}
}

