﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace SimplifiedEnumerator
{
	// uproszczona wersja klasy Pilgirm
	public class Pilgrim 
	{
		private string name;
		public Pilgrim(string name)
		{
			this.name = name;
		}
		public override string ToString()
		{
			return this.name;
		}

	}

	//  uproszczona wersja klasy listy
	class NotReallyALinkedList<T> : IEnumerable<T>
	{
		// wszystkie elementy listy są przechowywane w tablicy
		// o stałym rozmiarze
		T[] myArray;

		// konstruktor przyjmuje tablicę i umieszcza jej elementy we własnej tablicy
		public NotReallyALinkedList(T[] members)
		{
			myArray = members;
		}

		// implementacja głównej metody interfejsu IEnumerable
		IEnumerator<T> IEnumerable<T>.GetEnumerator()
		{
			foreach (T t in this.myArray)
			{
				yield return t;
			}
		}

		// wymagana implementacja również dla wersji niegenerycznej
      System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
      {
         throw new NotImplementedException();
      }
	}


	class Program
	{
		static void Main(string[] args)
		{
			// ręczne tworzenie tablicy obiektów klasy Pilgrim
			Pilgrim[] pilgrims = new Pilgrim[5];
			pilgrims[0] = new Pilgrim("Rycerz");
			pilgrims[1] = new Pilgrim("Młynarz");
			pilgrims[2] = new Pilgrim("Szeryf");
			pilgrims[3] = new Pilgrim("Kucharz");
			pilgrims[4] = new Pilgrim("Adwokat");

			// utworzenie listy,przekazanie tablicy elementów
			NotReallyALinkedList<Pilgrim> pilgrimCollection = 
				new NotReallyALinkedList<Pilgrim>(pilgrims);

			// przeglądanie elementów listy
			foreach (Pilgrim p in pilgrimCollection)
			{
				Console.WriteLine(p);
			}
		}
	}
}
