﻿using System;

namespace NullableTypes
{
	public class Dog
	{
		private int age;
		public Dog(int age)
		{
			this.age = age;
		}
	}	
	
	class Program
	{
		static void Main(string[] args)
		{
			int? myNullableInt = 25;
			double? myNullableDouble = 3.14159;
			bool? myNullableBool = null; // ani tak, ani nie

			// string? myNullableString = "Ahoj"; // niedozwolone
			// Dog? myNullableDog = new Dog(3);  // niedozwolone

			if (myNullableInt.HasValue)
			{
				Console.WriteLine("myNullableInt to" + myNullableInt.Value);
			}
			else
			{
				Console.WriteLine("myNullableInt ma wartość pustą!");
			}

			if (myNullableDouble != null)
			{
				Console.WriteLine("myNullableDouble: " + myNullableDouble);
			}
			else
			{
				Console.WriteLine("myNullableDouble ma wartość pustą!");
			}
			
			if ( myNullableBool != null )
			{
				Console.WriteLine("myNullableBool: " + myNullableBool);
			}
			else
			{
				Console.WriteLine("myNullableBool ma wartość pustą!");
			}


			myNullableInt = null;		// przypisanie wartości pustej do zmiennej całkowitej
			// int a = myNullableInt; // błąd kompilacji

			int b;
			try
			{
				b = (int)myNullableInt;  // sprowokuje wyjątek, kiedy x będzie puste
				Console.WriteLine("b: " + b);
			}
			catch (System.Exception e)
			{
				Console.WriteLine("Wyjątek! " + e.Message);
			}

			int c = myNullableInt ?? -1;  // przypisze -1, kiedy x będzie puste

			Console.WriteLine("c: {0}", c);

			// ostrożnie z założeniami
			// jeśli którykolwiek z operandów będzie pusty, wszelkie porównania dadzą wynik false!
			if (myNullableInt >= c)
			{
				Console.WriteLine("myNullableInt jest większe (równe) od c");
			}
			else
			{
				Console.WriteLine("Is myNullableInt jest mniejsze od c?");
			}

		}
	}
}
