Imports System.ComponentModel
Imports System.Drawing
Imports System.Windows.Forms

Public MustInherit Class PlotWindow
  Inherits System.Windows.Forms.Form
  'Klasa bazowa dla klas tworzcych rne rodzaje wykresw
  Protected xfactor As Single, xpmin As Single, xpmax As Single
  Protected xmin As Single, xmax As Single
  Protected ymin As Single, ymax As Single
  Protected yfactor As Single, ypmin As Single, ypmax As Single
  Protected x() As Single, y() As Single
  Protected bPen As Pen
  Protected hasData As Boolean
  Protected w As Integer, h As Integer
  Const max As Single = 1.0E+38

  Public Sub New()
    MyBase.New()
    PlotWindow = Me
    InitializeComponent()
  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal dispose As Boolean)
    MyBase.Dispose(dispose)
    components.Dispose()
  End Sub

#Region " Windows Form Designer generated code "

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container
  Dim WithEvents PlotWindow As System.Windows.Forms.Form

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Private Sub InitializeComponent()
    Me.components = New System.ComponentModel.Container()
    Me.Text = "Plot Window"
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
  End Sub

#End Region
  '----- 
  Public Sub setPenColor(ByVal c As Color)
    bPen = New Pen(c)
  End Sub
  '----- 
  Private Sub findBounds()
    Dim i As Integer
    xmin = max
    xmax = -max
    ymin = max
    ymax = -max

    For i = 0 To x.Length - 1
      If x(i) > xmax Then xmax = x(i)
      If x(i) < xmin Then xmin = x(i)
      If y(i) > ymax Then ymax = y(i)
      If y(i) < ymin Then ymin = y(i)
    Next i

  End Sub
  '-----    
  Public Overridable Shadows Sub set_Bounds(ByVal pic As PictureBox)
    findBounds()
    'Wylicz wspczynniki skalowania
    h = pic.Height
    w = pic.Width
    xfactor = 0.8F * w / (xmax - xmin)
    xpmin = 0.05F * w
    xpmax = w - xpmin

    yfactor = 0.9F * h / (ymax - ymin)
    ypmin = 0.05F * h
    ypmax = h - ypmin
    'Utwrz tablic kolorw dla supkw wykresu

  End Sub
  '-----    
  Public Function calcx(ByVal xp As Single) As Integer
    Dim ix As Integer
    ix = CType(((xp - xmin) * xfactor + xpmin), Int16)
    Return ix
  End Function
  '-----    
  Public Function calcy(ByVal yp As Single) As Integer
    Dim iy As Integer
    yp = CType(((yp - ymin) * yfactor), Integer)
    iy = CType((ypmax - yp), Integer)
    Return iy
  End Function
  '-----    
  Public Sub plot(ByVal xp() As Single, ByVal yp() As Single, ByVal pic As PictureBox)
    x = xp
    y = yp
    set_Bounds(pic)
    hasData = True
    repaint()
  End Sub

  Public MustOverride Sub repaint()

End Class
