Imports System.Drawing
Imports System.Windows.Forms
Imports System.ComponentModel

Public Class ColFrame
  Inherits System.Windows.Forms.Form
  Implements Observer
  Private colname As String
  Dim fnt As Font
  Dim bBrush As SolidBrush
  '-----
  Public Sub New(ByVal subj As Subject)
    MyBase.New()
    subj.registerInterest(Me)
    ColFrame = Me
    InitializeComponent()
    fnt = New Font("arial", 18, Drawing.FontStyle.Bold)
    bBrush = New SolidBrush(Color.Black)
    AddHandler Pic.Paint, New PaintEventHandler(AddressOf paintHandler)
  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

#Region " Windows Form Designer generated code "

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container
  Private WithEvents Pic As System.Windows.Forms.PictureBox

  Dim WithEvents ColFrame As System.Windows.Forms.Form

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Private Sub InitializeComponent()
    Me.components = New System.ComponentModel.Container()
    Me.Pic = New System.Windows.Forms.PictureBox()

    '@design Me.TrayHeight = 0
    '@design Me.TrayLargeIcon = False
    '@design Me.TrayAutoArrange = True
    Pic.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Pic.BackColor = System.Drawing.SystemColors.ActiveCaptionText
    Pic.Location = New System.Drawing.Point(16, 32)
    Pic.Size = New System.Drawing.Size(248, 184)
    Pic.TabIndex = 0
    Pic.TabStop = False

    Me.Text = "ColFrame"
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)

    Me.Controls.Add(Pic)
  End Sub

#End Region
  '-----
  Public Sub sendNotify(ByVal mesg As System.String) Implements vbnetObserver.Observer.sendNotify
    colname = mesg
    Select Case mesg.ToLower
      Case "red"
        Pic.BackColor = Color.Red '
      Case "blue"
        Pic.BackColor = Color.Blue
      Case "green"
        Pic.BackColor = Color.Green
    End Select
  End Sub
  '-----
  Private Sub paintHandler(ByVal sender As Object, ByVal e As PaintEventArgs)
    Dim g As Graphics = e.Graphics
    g.DrawString(colname, fnt, bBrush, 20, 40)
  End Sub

End Class
