Imports System.Collections
Imports System.Windows

Public Class KidForm
  Inherits System.Windows.Forms.Form
  Private Shared m_vb6FormDefInstance As KidForm
  Private components As System.ComponentModel.IContainer

  Public Shared Property DefInstance() As KidForm
    Get
      If m_vb6FormDefInstance Is Nothing Then
        m_vb6FormDefInstance = New KidForm()
      End If
      DefInstance = m_vb6FormDefInstance
    End Get
    Set(ByVal Value As KidForm)
      m_vb6FormDefInstance = Value
    End Set
  End Property

#Region " Windows Form Designer generated code "
  'Required by the Win Form Designer
  Public ToolTip1 As System.Windows.Forms.ToolTip
  Private WithEvents KidForm As KidForm
  Public WithEvents lscKids As System.Windows.Forms.ListBox
  Public WithEvents cbClubs As System.Windows.Forms.ComboBox
  Public WithEvents List1 As System.Windows.Forms.ListBox
  Public Sub New()
    MyBase.New()
    Me.KidForm = Me
    ' This call is required by the Win Form Designer
    If m_vb6FormDefInstance Is Nothing Then
      m_vb6FormDefInstance = Me
    End If
    InitializeComponent()
    Form_Load()
  End Sub
  ' Form overrides dispose to clean up the component list.
  Public Overloads Sub Dispose()
    MyBase.Dispose()
    components.Dispose()
  End Sub
  ' The main entry point for the application
  Shared Sub Main()
    System.Windows.Forms.Application.Run(New KidForm())
  End Sub
  ' NOTE: The following procedure is required by the Win Form Designer
  ' It can be modified using the Win Form Designer.
  ' Do not modify it using the code editor.

  Private Sub InitializeComponent()
    Me.components = New System.ComponentModel.Container()
    Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
    Me.lscKids = New System.Windows.Forms.ListBox()
    Me.cbClubs = New System.Windows.Forms.ComboBox()
    Me.List1 = New System.Windows.Forms.ListBox()
    Me.SuspendLayout()
    '
    'lscKids
    '
    Me.lscKids.BackColor = System.Drawing.SystemColors.Window
    Me.lscKids.Cursor = System.Windows.Forms.Cursors.Default
    Me.lscKids.ForeColor = System.Drawing.SystemColors.WindowText
    Me.lscKids.Location = New System.Drawing.Point(224, 56)
    Me.lscKids.Name = "lscKids"
    Me.lscKids.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.lscKids.Size = New System.Drawing.Size(121, 121)
    Me.lscKids.TabIndex = 2
    '
    'cbClubs
    '
    Me.cbClubs.BackColor = System.Drawing.SystemColors.Window
    Me.cbClubs.Cursor = System.Windows.Forms.Cursors.Default
    Me.cbClubs.ForeColor = System.Drawing.SystemColors.WindowText
    Me.cbClubs.Location = New System.Drawing.Point(224, 16)
    Me.cbClubs.Name = "cbClubs"
    Me.cbClubs.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.cbClubs.Size = New System.Drawing.Size(113, 21)
    Me.cbClubs.TabIndex = 1
    Me.cbClubs.Text = "Combo1"
    '
    'List1
    '
    Me.List1.BackColor = System.Drawing.SystemColors.Window
    Me.List1.Cursor = System.Windows.Forms.Cursors.Default
    Me.List1.ForeColor = System.Drawing.SystemColors.WindowText
    Me.List1.Location = New System.Drawing.Point(24, 32)
    Me.List1.Name = "List1"
    Me.List1.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.List1.Size = New System.Drawing.Size(161, 160)
    Me.List1.TabIndex = 0
    '
    'KidForm
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(362, 244)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lscKids, Me.cbClubs, Me.List1})
    Me.Location = New System.Drawing.Point(4, 23)
    Me.Name = "KidForm"
    Me.Text = "Kid List"
    Me.ResumeLayout(False)

  End Sub
#End Region

  Dim kidz As Kids
  Dim clubs As ArrayList
  Private Sub addClub(ByRef club As String)
    Dim i As Integer
    Dim found As Boolean
    found = False
    i = 0
    While i < clubs.Count And Not found
      found = (CType(clubs(i), String) = club)
      i = i + 1
    End While
    If Not found Then
      clubs.Add(club)
    End If
  End Sub

  Private Sub sortClubs()
    Dim cb(clubs.Count) As String
    Dim j, i, max As Integer
    Dim tmp As String

    max = clubs.Count()
    For i = 0 To max - 1
      cb(i) = CType(clubs(i), String)
    Next i
    For i = 0 To max - 1
      For j = i To max - 1
        If cb(i) > cb(j) Then
          tmp = cb(i)
          cb(i) = cb(j)
          cb(j) = tmp
        End If
      Next j
    Next i
    clubs = Nothing
    clubs = New ArrayList()
    For i = 0 To max - 1
      clubs.Add(cb(i))
    Next i
  End Sub

  Private Sub cbClubs_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cbClubs.SelectedIndexChanged
    Dim club As String
    Dim iter As IEnumerator
    Dim kd As Kid
    club = cbClubs.Text
    iter = kidz.getClubIterator(club)
    lscKids.Items.Clear()
    While iter.MoveNext
      kd = CType(iter.Current, Kid)
      lscKids.Items.Add(kd.getFrname & " " & kd.getLname)
    End While
  End Sub

  Private Sub Form_Load()
    Dim iter As IEnumerator
    Dim kd As Kid
    Dim i As Integer

    clubs = New ArrayList()
    kidz = New Kids(System.Windows.Forms.Application.StartupPath & "\50free.txt")
    'Inicjuj kolekcj
    'I wczytaj dane z pliku
    'Traktuj kolekcj jako iterator
    iter = kidz.getIterator
    While iter.MoveNext  ' Zaduj na list
      kd = CType(iter.Current, Kid)
      List1.Items.Add(kd.getFrname & " " & kd.getLname)
      addClub(kd.getClub)
    End While
    sortClubs()
    For i = 0 To clubs.Count() - 1
      cbClubs.Items.Add(clubs.Item(i))
    Next i
    cbClubs.SelectedIndex = 0
  End Sub

End Class
