Public Class Sort
  Inherits VERB
  Private kids() As Kid
  Private pindex As Integer

  Public Sub New(ByVal s As String, ByVal kd As Data, ByVal pt As ListBox)
    MyBase.new(s, kd, pt)
    value = SORTBY
  End Sub
  '-----------------------------------
  Public Overrides Sub Execute()
    Dim sortKey As Integer
    Dim a, k As Integer
    kids = Data.getData
    For a = 0 To args.Count - 1
      Dim v As ParseVar = CType(args(a), ParseVar)
      If (TypeOf (v) Is MultVar) Then
        Dim mv As MultVar = CType(v, MultVar)
        Dim mvec As ArrayList = mv.getVector()
        For k = mvec.Count - 1 To 0 Step -1
          Dim pv As ParseVar = CType(mvec(k), ParseVar)
          sortKey = pv.getValue()
          sortByKey(sortKey)
        Next k
      Else
        sortKey = v.getValue()
        sortByKey(sortKey)
      End If
    Next a
  End Sub
  '----------------------------------------
  Private Sub sortByKey(ByVal sortkey As Integer)
    Dim i, j As Integer
    For i = 0 To kids.Length - 1
      For j = i + 1 To kids.Length - 1
        If (comparev(i, j, sortkey)) Then
          Dim tmp As Kid = kids(i)
          kids(i) = kids(j)
          kids(j) = tmp
        End If
      Next j
    Next i
  End Sub
  '----------------------------------------
  Private Function comparev(ByVal i As Integer, ByVal j As Integer, ByVal key As Integer) As Boolean
    Dim cval As Boolean
    Select Case key
      Case ParseVar.FRNAME
        cval = kids(i).getFrname().CompareTo(kids(j).getFrname()) > 0
      Case ParseVar.LNAME
        cval = kids(i).getLname().CompareTo(kids(j).getLname()) > 0
      Case ParseVar.CLUB
        cval = kids(i).getClub().CompareTo(kids(i).getClub()) > 0
      Case ParseVar.AGE
        cval = kids(i).getAge() > kids(j).getAge()
      Case ParseVar.TIME
        cval = kids(i).getTime() > kids(j).getTime()
      Case Else
        cval = False
    End Select
    Return cval
  End Function

End Class
