Public Class KidData
  Private kids As ArrayList
  '------------------------------------------   
  Public Sub New(ByVal filename As String)
    MyBase.New()
    kids = New ArrayList()
    Dim f As vbFile = New vbFile(filename)
    f.OpenForRead()
    Dim s As String = f.readLine()
    While Not f.fEOF
      If (s.Trim().Length() > 0) Then
        Dim k As Kid = New Kid(s)
        kids.Add(k)
      End If
      s = f.readLine()
    End While
  End Sub
  '--------------------------------
  Public Function getData() As Kid()
    Dim i As Integer
    Dim kd(kids.Count - 1) As Kid
    For i = 0 To kids.Count - 1
      kd(i) = CType(kids(i), Kid)
    Next i
    Return kd
  End Function
  '--------------------------------
  Public Function size() As Integer
    Return kids.Count
  End Function
  '--------------------------------
  Public Function getKid(ByVal i As Integer) As Kid
    Return CType(kids(i), Kid)
  End Function
  '--------------------------------
  Public Function getKidData(ByVal key As Integer) As ArrayList
    Dim i As Integer
    Dim v As ArrayList = New ArrayList()
    For i = 0 To kids.Count - 1
      v.Add(getKid(i).getData(key))
    Next i
    Return v
  End Function
  '--------------------------------
  Public Function getTableKey(ByVal tabName As String) As Integer
    Dim key As Integer = -1
    tabName = tabName.ToLower
    Select Case tabName
      Case "frname"
        key = ParseVar.FRNAME
      Case "lname"
        key = ParseVar.LNAME
      Case "age"
        key = ParseVar.AGE
      Case "club"
        key = ParseVar.CLUB
      Case "time"
        key = ParseVar.TIME
    End Select
    Return key
  End Function
  '----------------------------
  Public Function getTableName(ByVal i As Integer) As String
    Dim name As String = ""
    Select Case i
      Case ParseVar.FRNAME
        name = "frname"
      Case ParseVar.LNAME
        name = "lname"
      Case ParseVar.AGE
        name = "age"
      Case ParseVar.CLUB
        name = "club"
      Case ParseVar.TIME
        name = "time"
    End Select
    Return name
  End Function
  '----------------------------
End Class
