VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Decorator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Klasa Decorator
Implements AbstractDecorator
Private pic As PictureBox
Private cTime As Variant
Private btText As String
Private isOver As Boolean

Public Sub init(pix As Control, caption As String)
  Set pic = pix
  btText = caption
End Sub

Public Sub tick()
  Dim thisTime As Variant, diff As Variant
  thisTime = Time
  diff = DateDiff("s", cTime, thisTime)
  If diff >= 0.5 And Not isOver Then
    drawLines True, pic.BackColor, False
    isOver = False
  End If
End Sub

Public Sub mouseMove(x As Single, y As Single)
  Dim h As Integer, w As Integer, col As Long
  h = pic.Height
  w = pic.Width

  If x < 8 Or y < 8 Or x > w - 16 Or y > h - 16 Then
    col = pic.BackColor
    drawLines True, col, False
    isOver = False
  Else
    cTime = Time
    col = vbBlack
    drawLines False, col, False
  End If
End Sub

Public Sub mouseDown()
  drawLines False, vbBlack, True
  isOver = True
End Sub

Public Sub mouseUp()
  isOver = False
  drawLines False, vbBlack, False
End Sub

Public Sub paint()
  Dim x As Integer, y As Integer, h As Integer
  x = 10
  h = pic.Height
  y = 0.33 * h
  pic.PSet (x, y), pic.BackColor
  pic.Print btText;
End Sub

Private Sub drawLines(hide As Boolean, col As Long, down As Boolean)
  Dim h As Integer, w As Integer
  h = pic.Height
  w = pic.Width
  If down Then
    col = vbBlack
    pic.Line (0, 0)-(w - 8, 0), col
    pic.Line -(w - 8, h - 8), col
    pic.Line -(0, h - 8), col
    pic.Line -(1, 1), col
  Else
    If hide Then
      pic.Line (0, 0)-(w - 8, 0), col
      pic.Line -(w - 8, h - 8), col
      pic.Line -(0, h - 8), col
      pic.Line -(1, 1), col
    Else
      pic.Line (0, 0)-(w - 8, 0), vbWhite
      pic.Line -(w - 8, h - 8), col
      pic.Line -(0, h - 8), col
      pic.Line -(1, 1), vbWhite
    End If
  End If
End Sub

Private Function AbstractDecorator_getControl() As Control
  Set AbstractDecorator_getControl = pic
End Function

Private Sub AbstractDecorator_init(c As Control, title As String)
  init c, title
End Sub

Private Sub AbstractDecorator_initContents(d As AbstractDecorator)

End Sub

Private Sub AbstractDecorator_mouseDown()
  mouseDown
End Sub

Private Sub AbstractDecorator_mouseMove(ByVal x As Single, ByVal y As Single)
  mouseMove x, y
End Sub

Private Sub AbstractDecorator_mouseUp()
  mouseUp
End Sub

Private Sub AbstractDecorator_paint()
  paint
End Sub

Private Sub AbstractDecorator_refresh()
  tick
End Sub
