Imports System
Imports System.IO
Imports System.ComponentModel

Public Class vbFile
  'hermetyzuje operacje odczytu, zapisu, sprawdzenia istnienia i usuwania plikw
  'dla plikw tekstowych

  Private opened As Boolean     'True jeli plik jest otwarty
  Private end_file As Boolean   'True jeli osignito koniec pliku
  Private errDesc As String     'tekst opisu ostatniego bdu
  Private File_name As String   'nazwa pliku
  Private fl As File
  Private ts As StreamReader
  Private tok As StringTokenizer
  Private tokLine As String
  Private fs As FileStream
  Private sw As StreamWriter
  Private errFlag As Boolean
  Private lineLength As Integer
  Private sep As String         'separator tokenw
  Private finfo As FileInfo
  '-----
  Public Sub New(ByVal filename As String)
    'Create new file instance 
    File_name = filename        'zapisz nazw pliku
    finfo = New FileInfo(File_name)
    tokLine = ""                'inicjalizacja obiektu tokenizer
    sep = ","                   'inicjalizacja separatora
  End Sub
  '----------------
  Public Overloads Function OpenForRead() As Boolean
    Return OpenForRead(File_name)
  End Function
  '----------------
  Public Overloads Function OpenForRead(ByVal Filename As String) As Boolean
    'otwiera plik
    File_name = Filename        'zapisz nazw pliku
    errFlag = False             'wyczy znacznik bdu
    end_file = False            'i znacznik koca pliku
    Try
      ts = File.OpenText(File_name)    'otwrz plik
    Catch e As Exception
      errDesc = e.Message       'zapisz tekst opisu bdu
      errFlag = True            'i znacznik bdu
    End Try
    Return Not errFlag          'zwraca False w przypadku bdu
  End Function

  Public Function readLine() As String
    'odzczyt pojedynczego wiersza z pliku
    Dim s As String
    Try
      s = ts.ReadLine        'odczyt jednego wiersza z pliku
      lineLength = s.Length  'wykrycie koca pliku (ReadLine zwraca Null)
    Catch e As Exception
      end_file = True        'wyjtek jeli koniec pliku (ustaw znacznik koca pliku)
      s = ""                 'zwraca pusty acuch znakw
    End Try
    Return s
  End Function

  'przykad innego rozwizania znajdowania koca pliku
  Public Function readLineE() As String
    'odczyt jednego wiersza z pliku
    Dim s As String
    If ts.Peek >= 0 Then      'pobranie nastpnego znaku
      s = ts.ReadLine         'jeli istniej nastpne znaki to wczytaj cay wiersz
      Return s
    Else
      end_file = True         'jeli nie ma nastpnych znakw to ustaw znacznik koca pliku
      Return ""
    End If
  End Function

  Public Function readToken() As String
    If (tokLine = "") Then
      tokLine = ts.ReadLine
    End If
    tok = New StringTokenizer(tokLine, sep)
    tokLine = tok.nextToken
    readToken = tokLine
  End Function

  Public Sub closeFile()
    Try
      ts.Close()
    Catch e As Exception
    End Try

    Try
      sw.Close()
    Catch e As Exception
    End Try


  End Sub
  Public Function isDirectory() As Boolean
    Return File.GetAttributes(File_name) = FileAttributes.Directory
  End Function
  Public Function exists() As Boolean
    exists = File.Exists(File_name)
  End Function

  Public Function getLastError() As String
    getLastError = errDesc
  End Function

  Public Overloads Function OpenForWrite(ByVal fname As String) As Boolean
    errFlag = False
    Try
      File_name = fname
      sw = File.CreateText(File_name)
    Catch e As Exception
      errDesc = e.Message
      errFlag = True
    End Try
    OpenForWrite = Not errFlag
  End Function
  '-------------
  Public Overloads Function OpenForWrite() As Boolean
    OpenForWrite = OpenForWrite(File_name)
  End Function
  '-------------
  Public Sub writeText(ByVal s As String)
    sw.WriteLine(s)             'zapis tekstu
  End Sub

  Public Sub setFilename(ByVal fname As String)
    File_name = fname
    finfo = New FileInfo(File_name)
  End Sub

  Public Function getFilename() As String
    getFilename = File_name
  End Function

  Public Function fEOF() As Boolean
    fEOF = end_file
  End Function
  Public Function length() As Long
    Return finfo.Length
  End Function
  Public Function rootName() As String
    Return finfo.Name
  End Function
  Public Function extension() As String
    Return finfo.Extension
  End Function
  Public Function path() As String
    Return finfo.DirectoryName
  End Function
End Class
