Option Strict Off
Option Explicit On

Friend Class Stock
  Private stockName As String     'Nazwa
  Private isMuniBond As Boolean   'Obligacja?
  Private investment As Single    'Wysoko inwestycji
  Private invDate As Date         'Data dokonania inwestycji
  Private rate_Renamed As Single  'Stopa wzrostu
  Public Sub init(ByRef nm As String, ByRef muniBond As Boolean)
    stockName = nm                'Zapamitaj nazw akcji
    isMuniBond = muniBond         'Oraz jej rodzaj
    If isMuniBond Then
      rate_Renamed = 0.05         'Niskie, ale stae oprocentowanie obligacji
    Else
      rate_Renamed = Rnd() / 10   'Losowe oprocentowanie akcji
    End If
  End Sub

  Public Sub invest(ByRef amt As Single)
    invDate = CDate(DateString)   'Zapamitaj dat
    investment = amt              'Oraz wysoko inwestycji
  End Sub

  Public Function getName() As String
    getName = stockName           'Zwr nazw papieru wartociowego
  End Function

  Public Function getValue(ByRef toDate As Date) As Single
    Dim diff As Object
    Dim value As Single
    'Oblicz aktualn warto inwestycji
    diff = DateDiff(Microsoft.VisualBasic.DateInterval.Day, invDate, toDate)
    value = (diff / 365) * rate_Renamed * investment + investment
    getValue = value
  End Function

  Public Function getTaxable(ByRef toDate As Date) As Single
    If isMuniBond Then
      getTaxable = 0              'Nie podlega opodatkowaniu
    Else
      'Zwr dochd podlegajcy opodatkowaniu
      getTaxable = getValue(toDate) - investment
    End If
  End Function

  Public Function isBond() As Boolean
    isBond = isMuniBond
  End Function

End Class