Public Class StForm
  Inherits System.Windows.Forms.Form
  Private CircButton As CircleButton
  Private RctButton As RectButton
  Private ArowButton As PickButton
  Private flbutton As FillButton
  Private undoB As UndoButton
  Private clrb As ClearButton
  Friend WithEvents Pic As System.Windows.Forms.PictureBox
  Private med As Mediator

  Private Sub init()
    'Wywoywana przez konstruktor
    'Utwrz mediatora
    med = New Mediator(Pic)
    'Oraz przyciski
    RctButton = New RectButton(med)
    ArowButton = New PickButton(med)
    CircButton = New CircleButton(med)
    flbutton = New FillButton(med)
    undoB = New UndoButton(med)
    clrb = New ClearButton(med)
    'Umie przyciski w pasku
    TBar.Buttons.Add(ArowButton)
    TBar.Buttons.Add(RctButton)
    TBar.Buttons.Add(CircButton)
    TBar.Buttons.Add(flbutton)
    'Ustaw separator
    Dim sep As New ToolBarButton()
    sep.Style = ToolBarButtonStyle.Separator
    TBar.Buttons.Add(sep)
    TBar.Buttons.Add(undoB)
    TBar.Buttons.Add(clrb)
  End Sub

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call
    init()
  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents ToolBar1 As System.Windows.Forms.ToolBar
  Friend WithEvents TBar As System.Windows.Forms.ToolBar

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.TBar = New System.Windows.Forms.ToolBar()
    Me.Pic = New System.Windows.Forms.PictureBox()
    Me.SuspendLayout()
    '
    'TBar
    '
    Me.TBar.DropDownArrows = True
    Me.TBar.Name = "TBar"
    Me.TBar.ShowToolTips = True
    Me.TBar.Size = New System.Drawing.Size(292, 22)
    Me.TBar.TabIndex = 0
    '
    'Pic
    '
    Me.Pic.BackColor = System.Drawing.SystemColors.ActiveCaptionText
    Me.Pic.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Pic.Location = New System.Drawing.Point(0, 40)
    Me.Pic.Name = "Pic"
    Me.Pic.Size = New System.Drawing.Size(288, 200)
    Me.Pic.TabIndex = 1
    Me.Pic.TabStop = False
    '
    'StForm
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(292, 273)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Pic, Me.TBar})
    Me.Name = "StForm"
    Me.Text = "State demo"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub TBar_ButtonClick( _
          ByVal sender As System.Object, _
          ByVal e As System.Windows.Forms.ToolBarButtonClickEventArgs) _
          Handles TBar.ButtonClick
    Dim cmd As Command
    Dim tbutn As ToolBarButton = e.Button
    cmd = CType(tbutn, Command)   'Pobierz obiekt polece
    cmd.Execute()                 'I wykonaj go
  End Sub

  Private Sub Pic_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseDown
    med.mouseDown(e.X, e.Y)
  End Sub

  Private Sub Pic_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseUp
    med.mouseUp(e.X, e.Y)
  End Sub

  Private Sub Pic_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseMove
    If e.Button <> MouseButtons.None Then
      med.mouseDrag(e.X, e.Y)
    End If
  End Sub

  Private Sub Pic_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Pic.Paint
    med.reDraw(e.Graphics)
  End Sub

End Class
