Imports System.Drawing

Public Class visRectangle
  Private x, y, w, h As Single
  Private rect As vbPatterns.Rectangle
  Private selected As Boolean
  Private bPen As Pen
  Private bBrush As SolidBrush
  '-----
  Public Sub New(ByVal xp As Integer, ByVal yp As Integer)
    x = xp                        'Przechowaj wsprzdne
    y = yp
    w = 40                        'Domylne rozmiary
    h = 30
    saveAsRect()
    bPen = New Pen(Color.Black)
    bBrush = New SolidBrush(Color.Black)
  End Sub
  '-----
  'Metody waciwoci stosowane do przechowania i odtworzenia stanu
  Friend Property rects() As vbPatterns.Rectangle
    Set(ByVal Value As vbPatterns.Rectangle)
      x = Value.x
      y = Value.y
      w = Value.w
      h = Value.h
      saveAsRect()
    End Set
    Get
      Return rect
    End Get
  End Property
  '-----
  Public Sub setSelected(ByVal b As Boolean)
    selected = b
  End Sub
  '-----
  'Przechowaj wartoci w instancji klasy Rectangle
  Private Sub saveAsRect()
    rect = New vbPatterns.Rectangle(x, y, w, h)
  End Sub
  '-----
  'Narysuj prostokt i uchwyty
  Public Sub draw(ByVal g As Graphics)
    'Rysuj prostokt
    g.DrawRectangle(bPen, x, y, w, h)

    If selected Then   'Rysuj uchwyty
      g.FillRectangle(bBrush, x + w / 2, y - 2, 4, 4)
      g.FillRectangle(bBrush, x - 2, y + h / 2, 4, 4)
      g.FillRectangle(bBrush, x + (w / 2), y + h - 2, 4, 4)
      g.FillRectangle(bBrush, x + (w - 2), y + (h / 2), 4, 4)
    End If
  End Sub
  '-----
  Public Function contains(ByVal xp As Integer, ByVal yp As Integer) As Boolean
    contains = rect.contains(xp, yp)
  End Function
  '-----
  Public Sub move(ByVal xpt As Integer, ByVal ypt As Integer)
    x = xpt
    y = ypt
    saveAsRect()
  End Sub

End Class
