Public Class Form1
  Inherits System.Windows.Forms.Form
  Private commands As Hashtable
  Private med As Mediator
  Friend WithEvents Pic As System.Windows.Forms.PictureBox
  Friend WithEvents Tbar As System.Windows.Forms.ToolBar
  Friend WithEvents btRect As System.Windows.Forms.ToolBarButton
  Friend WithEvents btundo As System.Windows.Forms.ToolBarButton
  Friend WithEvents btClear As System.Windows.Forms.ToolBarButton
  Private mouse_down As Boolean

  Private Sub init()
    'Wywoywana przez konstruktor
    med = New Mediator(Pic)     'Utwrz mediatora
    commands = New Hashtable()  'Oraz instancj Hashtable
    'Utwrz obiekty polece
    Dim rbutn As New RectButton(med, Tbar.Buttons(0))
    Dim ubutn As New UndoButton(med, Tbar.Buttons(1))
    Dim clrbutn As New Clearbutton(med)
    'Umie je w tablicy z kodowaniem mieszajcym
    commands.Add(btRect.GetHashCode, rbutn)
    commands.Add(btundo.GetHashCode, ubutn)
    commands.Add(btClear.GetHashCode, clrbutn)
    AddHandler Pic.Paint, New PaintEventHandler(AddressOf paintHandler)
  End Sub

  Protected Sub paintHandler(ByVal sender As Object, ByVal e As PaintEventArgs)
    Dim g As Graphics = e.Graphics
    med.reDraw(g)
  End Sub

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call
    init()

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.btClear = New System.Windows.Forms.ToolBarButton()
    Me.Pic = New System.Windows.Forms.PictureBox()
    Me.btundo = New System.Windows.Forms.ToolBarButton()
    Me.Tbar = New System.Windows.Forms.ToolBar()
    Me.btRect = New System.Windows.Forms.ToolBarButton()
    Me.SuspendLayout()
    '
    'btClear
    '
    Me.btClear.Text = "Clear"
    '
    'Pic
    '
    Me.Pic.BackColor = System.Drawing.SystemColors.ActiveCaptionText
    Me.Pic.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Pic.Location = New System.Drawing.Point(8, 48)
    Me.Pic.Name = "Pic"
    Me.Pic.Size = New System.Drawing.Size(296, 184)
    Me.Pic.TabIndex = 1
    Me.Pic.TabStop = False
    '
    'btundo
    '
    Me.btundo.Text = "Undo"
    '
    'Tbar
    '
    Me.Tbar.Buttons.AddRange(New System.Windows.Forms.ToolBarButton() {Me.btRect, Me.btundo, Me.btClear})
    Me.Tbar.DropDownArrows = True
    Me.Tbar.Name = "Tbar"
    Me.Tbar.ShowToolTips = True
    Me.Tbar.Size = New System.Drawing.Size(312, 39)
    Me.Tbar.TabIndex = 0
    '
    'btRect
    '
    Me.btRect.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton
    Me.btRect.Text = "Rectangle"
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(312, 237)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Pic, Me.Tbar})
    Me.Name = "Form1"
    Me.Text = "Memento Rectangles"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub ToolBar1_ButtonClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ToolBarButtonClickEventArgs) Handles Tbar.ButtonClick
    Dim cmd As Command
    Dim tbutn As ToolBarButton = e.Button
    cmd = CType(commands(tbutn.GetHashCode), Command)
    cmd.Execute()
  End Sub

  Private Sub Pic_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseUp
    mouse_down = False
  End Sub

  Private Sub Pic_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseDown
    mouse_down = True
    med.createRect(e.X, e.Y)
  End Sub

  Private Sub Pic_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Pic.MouseMove
    If mouse_down Then
      med.drag(e.X, e.Y)
    End If
  End Sub

End Class
