VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "vbFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'vbFile class
'encapsulates the common read, write, exists and delete methods
'for text file manipulation
Private f As Integer        'file handle
Private opened As Boolean   'true if file is open
Private end_file As Boolean 'true if at end of file
Private errDesc As String   'text of last error message
Private File_name As String 'name of file
Private rootName As String
'-----
Public Function OpenForRead(Filename As String) As Boolean
'open file for reading
f = FreeFile                'get a free handle
File_name = Filename        'save the filename

On Local Error GoTo nofile  'trap errors
    Open Filename For Input As #f
    opened = True           'set true if open successful
oexit:
    OpenForRead = opened    'return to caller
Exit Function
'--error handling--
nofile:
  end_file = True           'set end of file flag
  errDesc = Err.Description 'save error message
  opened = False            'no file open
  Resume oexit              'and resume
End Function
Public Function fEof() As Boolean
'return end of file
If opened Then
 fEof = EOF(f)
Else
 fEof = True    'if not opened then end file is true
End If
End Function
Public Function readLine() As String
Dim s As String
'read one line from a text file
If opened Then
  Line Input #f, s
  readLine = s
Else
  readLine = ""
End If
End Function
Public Function readToken() As String
Dim s As String
'read one token up to next comma delimiter
If opened Then
  Input #f, s
  readToken = s
Else
  readToken = ""
End If

End Function
Public Sub closeFile()
'close the file
 If opened Then
    Close #f
    opened = False
 End If
End Sub
Public Function exists() As Boolean
'returns true if the file exists
On Local Error GoTo exerr
 exists = Len(Dir$(File_name)) > 0
 Exit Function
exerr:
  errDesc = Err.Description
  Resume Next
End Function

Public Function getLastError() As String
  'ger description of last error
  getLastError = errDesc
End Function
Public Function delete() As Boolean
Dim success As Boolean
'delete the file
On Local Error GoTo nodel
If opened Then           'close before deleting
  Close #f
End If
If exists() Then
  Kill File_name        'delete the file
  success = True
Else
  errDesc = "File not found"    'or set error
End If

delex:
    delete = success    'return success flag
Exit Function
'---error handling
nodel:
    errDesc = Err.Description
    success = False
    Resume Next
End Function
Public Function OpenForWrite(fname As String) As Boolean
File_name = fname
On Local Error GoTo nowfile
Open fname For Output As #f
opened = True
owexit:
OpenForWrite = opened
Exit Function
nowfile:
  end_file = True
  errDesc = Err.Description
  Resume owexit
  opened = False
End Function
Public Sub writeText(s As String)
Print #f, s;
End Sub
Public Sub writeLine(s As String)
Print #f, s
End Sub
Public Sub setFilename(fname As String)
Dim i As Integer
File_name = fname
 rootName = fname
 i = InStr(rootName, "\")
 While i > 0
   rootName = Right(rootName, Len(rootName) - 1)
   i = InStr(rootName, "\")
 Wend
 
End Sub
Public Function getRoot() As String
  getRoot = rootName
End Function
Public Function getFilename() As String
getFilename = File_name
End Function
