Public Class DataLoader
  Private vfile As vbFile
  Private stor As Stores
  Private fods As Foods
  Private price As Prices
  Private db As DBase
  '--------------
  Public Sub New(ByVal datab As DBase)
    db = datab
    stor = New Stores(db)         'Utwrz instancje klas
    fods = New Foods(db)
    price = New Prices(db)
  End Sub
  '--------------
  Public Sub load(ByVal datafile As String)
    Dim sline As String
    Dim storekey As Long, foodkey As Long
    Dim tok As StringTokenizer

    'Usu zawarto tabel
    stor.delete()
    fods.delete()
    price.delete()
    'I wczytaj now
    vfile = New vbFile(datafile)
    vfile.OpenForRead()
    sline = vfile.readLine

    Dim nfi As NumberFormatInfo
    nfi = New NumberFormatInfo()
    nfi.NumberDecimalSeparator = "."


    While (sline <> "")
      tok = New StringTokenizer(sline, ",")
      stor.addTableValue(tok.nextToken)
      fods.addTableValue(tok.nextToken)
      sline = vfile.readLine
    End While
    vfile.closeFile()
    'Utwrz tabele Store i Food
    stor.makeTable("StoreName")
    fods.makeTable("FoodName")
    vfile.OpenForRead()
    sline = vfile.readLine
    While (sline <> "")
      tok = New StringTokenizer(sline, ",")
      storekey = stor.getKey(tok.nextToken, "Storekey")
      foodkey = fods.getKey(tok.nextToken, "Foodkey")
      price.addRow(storekey, foodkey, Single.Parse(tok.nextToken, nfi))
      sline = vfile.readLine
    End While
    price.makeTable()
    vfile.closeFile()
  End Sub
End Class
