Imports System.ComponentModel
Imports System.Drawing
Imports System.Windows.Forms

Public Class DecoPanel
  Inherits System.Windows.Forms.Panel
  Private bPen, wpen, gpen As Pen
  Private c As Control
  Private gotControl As Boolean
  Private mouse_over As Boolean
  Private x1, y1, x2, y2 As Single
  Public Sub New()
    MyBase.New()
    'This call is required by the Win Form Designer.
    InitializeComponent()
    'Utwrz biay i czarny pdzel
    bPen = New Pen(System.Drawing.Color.Black, 1)
    wpen = New Pen(System.Drawing.Color.White, 1)
    gotControl = False
  End Sub

  'overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  '-----
  Public Sub ctMouseEnter(ByVal sender As Object, ByVal e As EventArgs)
    mouse_over = True
    Refresh()
  End Sub
  '-----
  Public Sub ctMouseLeave(ByVal sender As Object, ByVal e As EventArgs)
    mouse_over = False
    Refresh()
  End Sub
  '-----
  Public Sub ctMouseMove(ByVal sender As Object, ByVal e As MouseEventArgs)
    mouse_over = True
  End Sub
  '-----
  Public Sub ctPaint(ByVal sender As Object, ByVal e As PaintEventArgs)
    'Rysuje ramk w obszarze przycisku 
    Dim g As Graphics = e.Graphics
    Const d = 1
    'Najpierw wypenij obszar kolorem szarym
    g.DrawRectangle(gpen, 0, 0, x2 - 1, y2 - 1)
    'Narysuj bia i czarn obwdk
    'Jeli mysz ponad przyciskiem
    If mouse_over Then
      g.DrawLine(bPen, 0, 0, x2 - d, 0)
      g.DrawLine(bPen, 0, 0, 0, y2 - 1)
      g.DrawLine(wpen, 0, y2 - d, x2 - d, y2 - d)
      g.DrawLine(wpen, x2 - d, 0, x2 - d, y2 - d)
    End If
  End Sub
#Region " Windows Form Designer generated code "

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  Dim WithEvents DecoPanel As System.Windows.Forms.UserControl

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Private Sub InitializeComponent()
    components = New System.ComponentModel.Container()
  End Sub

#End Region

  Protected Overrides Sub OnPaint(ByVal e As System.Windows.Forms.PaintEventArgs)
    'Pobierz informacje o kontrolce
    If Not gotControl Then        'Tylko jeden raz
      'Pobierz kontrolk
      c = CType(Me.Controls(0), Control)
      'Ustaw wymiary panelu wiksze o 1 punkt
      Dim sz As Size
      sz.Width = c.Size.Width + 2
      sz.Height = c.Size.Height + 2
      Me.Size = sz
      x1 = c.Location.X - 1
      y1 = c.Location.Y - 1
      x2 = c.Size.Width
      y2 = c.Size.Height
      'Utwrz pdzel
      gpen = New Pen(c.BackColor, 2)
      gotControl = True
      Dim evh As EventHandler = New EventHandler(AddressOf ctMouseEnter)
      AddHandler c.MouseHover, evh
      AddHandler c.MouseEnter, evh
      AddHandler c.MouseMove, New MouseEventHandler(AddressOf ctMouseMove)
      AddHandler c.MouseLeave, New EventHandler(AddressOf ctMouseLeave)
      AddHandler c.Paint, New PaintEventHandler(AddressOf ctPaint)
    End If
  End Sub
End Class
