Imports System
Imports System.ComponentModel
Imports System.Drawing
Imports System.Windows.Forms
Imports System.Collections

Public Class Employee
  Implements AbstractEmployee
  Private nm As String
  Private salary As Single
  Protected subordinates As ArrayList
  '--------
  Public Overridable Overloads Sub add(ByVal nm As String, ByVal salary As Single) _
          Implements AbstractEmployee.add
    Throw New Exception("No subordinates in base employee class")
  End Sub
  '--------
  Public Overridable Overloads Sub add(ByVal emp As AbstractEmployee) _
          Implements AbstractEmployee.add
    Throw New Exception("No subordinates in base employee class")
  End Sub
  '--------
  Public Overridable Function getChild(ByVal nm As String) As AbstractEmployee _
          Implements AbstractEmployee.getChild
    Throw New Exception("No subordinates in base employee class")
  End Function
  '--------
  Public Function getName() As String Implements AbstractEmployee.getName

    Return nm
  End Function
  '--------
  Public Function getSalaries() As Single _
          Implements AbstractEmployee.getSalaries
    Dim sum As Single
    Dim esub As AbstractEmployee
    Dim enumSub As IEnumerator
    'Pobierz zarobki pracownika i jego podwadnych
    sum = getSalary()
    enumSub = subordinates.GetEnumerator
    While enumSub.MoveNext
      esub = CType(enumSub.Current, AbstractEmployee)
      sum = sum + esub.getSalaries
    End While
    Return sum
  End Function
  '--------
  Public Function getSalary() As Single _
          Implements AbstractEmployee.getSalary
    Return salary
  End Function
  '--------
  Public Function getSubordinates() As IEnumerator _
          Implements AbstractEmployee.getSubordinates
    Return subordinates.GetEnumerator
  End Function
  '--------
  Public Function getEnumerator() As IEnumerator _
    Implements AbstractEmployee.GetEnumerator
    Return subordinates.GetEnumerator
  End Function
  '--------

  Public Sub New(ByVal name As String, ByVal money As Single)
    MyBase.New()
    nm = name
    salary = money
    subordinates = New ArrayList()
  End Sub
  '--------
  Public Overridable Function isLeaf() As Boolean Implements AbstractEmployee.isLeaf
    Return True
  End Function

  '--------
  Public Sub remove(ByVal emp As AbstractEmployee) _
          Implements AbstractEmployee.remove
    Throw New Exception("No subordinates in base employee class")
  End Sub

End Class
