Imports System.ComponentModel
Imports System.Collections

Public MustInherit Class Seeding
  Protected numLanes As Integer
  Protected laneOrder As ArrayList
  Protected numHeats As Integer

  Private asw() As Swimmer
  Protected sw As Swimmers

  '-----
  Public Function getSeeding() As Swimmers
    getSeeding = sw
  End Function
  '-----
  Public Function getHeat() As Integer
  End Function
  '-----
  Public Function getCount() As Integer
    getCount = sw.Count
  End Function
  '-----
  Public MustOverride Sub seed()
  '-----
  Public Function getSwimmers() As ArrayList
    getSwimmers = sw
  End Function
  '-----
  Public Function getHeats() As Integer
    Return numHeats
  End Function
  '-----
  Public Function odd(ByVal n As Integer) As Boolean
    odd = (n \ 2) * 2 <> n
  End Function
  '-----
  Public Function calcLaneOrder(ByVal lns As Integer) As ArrayList
    numLanes = lns
    Dim lanes(numLanes) As Integer
    Dim i As Integer
    Dim mid, incr, ln As Integer
    mid = (numLanes \ 2)
    If (odd(numLanes)) Then
      mid = mid + 1       'start in middle lane
    End If


    incr = 1
    ln = mid
    For i = 0 To numLanes - 1
      lanes(i) = ln
      ln = mid + incr
      incr = -incr
      If (incr > 0) Then
        incr = incr + 1
      End If
    Next i

    laneOrder = New ArrayList()
    For i = 0 To numLanes - 1
      laneOrder.Add(lanes(i))
    Next i
    calcLaneOrder = laneOrder
  End Function

  Public Sub New(ByVal swmrs As Swimmers, ByVal lanes As Integer)
    MyBase.New()
    sw = swmrs
    numLanes = lanes
  End Sub
  '-------------------
  Public Function sort(ByVal sw As Swimmers) As Swimmers

    Dim i, j, max As Integer
    Dim tmp As Swimmer

    Try
      max = sw.Count
      Dim asw(max) As Swimmer

      For i = 0 To max - 1

        asw(i) = CType(sw.Item(i), Swimmer)
      Next i
      For i = 0 To max - 1
        For j = i To max - 1
          If asw(i).getTime > asw(j).getTime Then
            tmp = asw(i)
            asw(j) = asw(i)
            asw(i) = tmp
          End If
        Next j
      Next i

      sw = New Swimmers()
      For i = 0 To max - 1
        sw.Add(asw(i))
      Next i

      sort = sw
    Catch e As Exception
      Console.WriteLine("Caught " + i.ToString + " " + j.ToString + " " + max.ToString + " " + e.ToString())
      Console.WriteLine(e.StackTrace)
    End Try


  End Function

End Class

