VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Stock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private stockName As String       'Nazwa
Private isMuniBond As Boolean     'Obligacja
Private investment As Single      'Wysoko inwestycji
Private invDate As Date           'Data dokonania inwestycji
Private rate As Single            'Stopa wzrostu

Public Sub init(nm As String, muniBond As Boolean)
  stockName = nm                  'Zapamietaj nazw akcji
  isMuniBond = muniBond           'Oraz jej rodzaj
  If isMuniBond Then
    rate = 0.05                   'Niskie, ale stae oprocentowanie obligacji
  Else
    rate = Rnd / 10               'Losowe oprocentowanie akcji
  End If
End Sub

Public Sub invest(amt As Single)
  invDate = CVDate(Date$)         'Zapamitaj dat
  investment = amt                'Oraz wysoko inwestycji
End Sub

Public Function getName() As String
  getName = stockName             'Zwr nazw papieru wartociowego
End Function

Public Function getValue(toDate As Date) As Single
  Dim diff, value As Single
  'Oblicz aktualn warto inwestycji
  diff = DateDiff("d", invDate, toDate)
  value = (diff / 365) * rate * investment + investment
  getValue = value        'I zwr j
End Function

Public Function getTaxable(toDate As Date) As Single
  If isMuniBond Then
    getTaxable = 0                'Nie podlega opodatkowaniu
  Else
    'Zwr dochd podlegajcy opodatkowaniu
    getTaxable = getValue(toDate) - investment
  End If
End Function

Public Function isBond() As Boolean
  isBond = isMuniBond
End Function
