Option Strict Off
Option Explicit On

Friend Class Times
  Dim t As Single
  Dim errflag As Boolean
  Private Const tmNT As Short = 10000
  Private Const tmDQ As Short = 20000
  Private Const tmSCRATCH As Short = 30000
  Dim minVal As Single
  'Klasa uywana jest do odczytu i formatowania uzyskanych czasw
  'i zawiera rwnie deklaracj staych

  ReadOnly Property NT() As Single
    Get
      NT = tmNT
    End Get
  End Property

  ReadOnly Property SCRATCH() As Single
    Get
      SCRATCH = tmSCRATCH
    End Get
  End Property

  ReadOnly Property DQ() As Single
    Get
      DQ = tmDQ
    End Get
  End Property

  Public Sub setSingle(ByRef tv As Single)
    t = tv
    If tv > minVal And tv <> tmNT Then
      t = tv / 100
    End If
  End Sub

  Public Sub setSeconds(ByRef secs As Single)
    t = (secs \ 60) * 100
    t = t + (secs - (60 * t \ 100))
  End Sub

  Public Function getSingle() As Object
    getSingle = t
  End Function

  Public Function getFormatted() As String
    Dim mins As Short
    Dim secs As Single
    Dim S As String
    If t >= 100 And t < 3000 Then
      mins = t \ 100
      secs = t - mins * 100
    Else
      secs = t
    End If
    If mins > 0 Then
      S = Trim(Str(mins)) & ":" & VB6.Format(secs, "00.00")
      getFormatted = S
    Else
      getFormatted = VB6.Format(secs, "##.00")
    End If
    If t = NT Or t = 0 Then
      getFormatted = "NT"
    End If
    If t = DQ Then
      getFormatted = "DQ"
    End If
    If t = SCRATCH Then
      getFormatted = "SCR"
    End If
  End Function

  Public Function setText(ByVal tx As String) As Boolean
    Dim i As Short
    Dim mins As Integer
    Dim secs As Single
    errflag = False
    i = InStr(tx, ":")
    If i > 0 Then
      mins = Val(Left(tx, i - 1))
      secs = Val(Right(tx, Len(tx) - i))
      If secs > 59.99 Then
        errflag = True
      End If
      t = mins * 100 + secs
    Else
      mins = Val(tx) \ 100
      secs = Val(tx) - (100 * mins)
      If secs > 59.99 Then
        errflag = True
        t = NT
      Else
        setSingle(Val(tx))
      End If
    End If
    If Left(UCase(tx), 1) = "S" Then
      t = SCRATCH
    End If
    If Left(UCase(tx), 1) = "D" Then
      t = DQ
    End If
    setText = Not errflag             'True jeli OK, False jeli bd
  End Function

  Public Function getSeconds() As Single
    Dim mins As Short
    Dim secs As Single

    mins = t \ 100
    secs = t - mins * 100
    getSeconds = mins * 60 + secs
  End Function

  Private Function getMinutes(ByRef t As Single) As Single
    Dim mins As Short
    Dim secs As Single
    mins = t \ 60
    secs = t - mins * 60
    getMinutes = mins * 100 + secs
  End Function

  Public Function multiply(ByRef tval As Single) As Single
    Dim temp As Single
    temp = t
    If (t <> NT) Then
      temp = getMinutes(tval * getSeconds())
    End If
    multiply(temp)
  End Function

  Public Function divide(ByRef tval As Single) As Single
    Dim temp As Single
    temp = t
    If tval <> 0 And tval <> NT Then
      temp = getMinutes(getSeconds() / tval)
    End If
    divide = temp
  End Function

  Private Sub Class_Initialize_Renamed()
    minVal = 10000
  End Sub

  Public Sub New()
    MyBase.New()
    Class_Initialize_Renamed()
  End Sub

End Class