VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Times"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Dim t As Single
Dim errflag As Boolean
Private Const tmNT = 10000, tmDQ = 20000, tmSCRATCH = 30000
Dim minVal As Single
'Klasa suca do przechowywania i formatowania wynikw zawodnikw

Property Get NT() As Single
  NT = tmNT
End Property

Property Get SCRATCH() As Single
  SCRATCH = tmSCRATCH
End Property

Property Get DQ() As Single
  DQ = tmDQ
End Property

Public Sub setSingle(tv As Single)
  t = tv
  If tv > minVal And tv <> tmNT Then
    t = tv / 100
  End If
End Sub

Public Sub setSeconds(secs As Single)
  t = (secs \ 60) * 100
  t = t + (secs - (60 * t \ 100))
End Sub

Public Function getSingle()
  getSingle = t
End Function

Public Function getFormatted() As String
  Dim mins As Integer, secs As Single, s$
  If t >= 100 And t < 3000 Then
    mins = t \ 100
    secs = t - mins * 100
  Else
    secs = t
  End If
  If mins > 0 Then
    s$ = Trim$(Str$(mins)) + ":" & Format$(secs, "00.00")
    getFormatted = s$
  Else
    getFormatted = Format$(secs, "##.00")
  End If
  If t = NT Or t = 0 Then
    getFormatted = "NT"
  End If
  If t = DQ Then
    getFormatted = "DQ"
  End If
  If t = SCRATCH Then
    getFormatted = "SCR"
  End If
End Function

Public Function setText(ByVal tx As String) As Boolean
  Dim i As Integer, mins As Long, secs As Single
  errflag = False
  tx = Replace(tx, ",", ".")
  i = InStr(tx, ":")
  If i > 0 Then
    mins = Val(Left$(tx, i - 1))
    secs = Val(Right$(tx, Len(tx) - i))
    If secs > 59.99 Then
      errflag = True
    End If
    t = mins * 100 + secs
  Else
    mins = Val(tx) \ 100
    secs = Val(tx) - (100 * mins)
    If secs > 59.99 Then
      errflag = True
      t = NT
    Else
      setSingle Val(tx)
    End If
  End If
  If Left$((UCase$(tx)), 1) = "S" Then
    t = SCRATCH
  End If
  If Left$(UCase$(tx), 1) = "D" Then
    t = DQ
  End If
  setText = Not errflag   'true if OK, false if error
End Function

Public Function getSeconds() As Single
  Dim mins As Integer, secs As Single

  mins = t \ 100
  secs = t - mins * 100
  getSeconds = mins * 60 + secs
End Function

Private Function getMinutes(t As Single) As Single
  Dim mins As Integer, secs As Single
  mins = t \ 60
  secs = t - mins * 60
  getMinutes = mins * 100 + secs
End Function

Public Function multiply(tval As Single) As Single
  Dim temp As Single
  temp = t
  If (t <> NT) Then
    temp = getMinutes(tval * getSeconds)
  End If
  multiply = temp
End Function

Public Function divide(tval As Single) As Single
  Dim temp As Single
  temp = t
  If tval <> 0 And tval <> NT Then
    temp = getMinutes(getSeconds / tval)
  End If
  divide = temp
End Function

Private Sub Class_Initialize()
  minVal = 10000
End Sub
