Imports System.Collections

Public Class ArrowState
  Inherits State
  Private med As Mediator

  Public Sub New(ByVal md As Mediator)
    med = md
  End Sub

  Public Overrides Sub mouseDown(ByVal x As Integer, ByVal y As Integer)
    Dim i As Integer
    Dim found As Boolean
    med.unpick()
    med.startArrow()
    i = med.findDrawing(x, y)
    If (i >= 0) Then
      med.setSelected(i)
      med.rememberPosition()
    End If
  End Sub

  Public Overrides Sub mouseDrag(ByVal x As Integer, ByVal y As Integer)
    Dim i As Integer
    Dim d As Drawing
    i = med.findDrawing(x, y)
    If i >= 0 Then
      d = med.getDrawing(i)
      d.move(x, y)
    End If
  End Sub

End Class
