Imports System.Collections

Public Class CareTaker
  Private drawings As ArrayList
  Private undoList As ArrayList

  Public Sub init(ByVal dcol As ArrayList)
    drawings = dcol
    undoList = New ArrayList()
  End Sub
  '------------------------------------
  Public Sub rememberPosition(ByVal vrect As visRectangle)
    Dim m As Memento
    m = New Memento(vrect)
    undoList.Add(m)
  End Sub
  '------------------------------------
  Public Sub clear(ByVal drw As ArrayList)
    undoList = New ArrayList()
    drawings = drw
  End Sub
  '------------------------------------
  Public Sub add(ByVal intObj As Integer)
    undoList.Add(intObj)
  End Sub
  '------------------------------------
  Private Sub removeDrawing()
    drawings.RemoveAt(drawings.Count - 1)
  End Sub
  '------------------------------------
  Private Sub remove(ByVal obj As Memento)
    obj.restore()
  End Sub
  '-----------------------------------
  Public Sub undo()
    Dim obj As Object
    If undoList.Count > 0 Then
      'Pobierz ostatni element listy wycofa
      obj = undoList(undoList.Count - 1)
      If (TypeOf obj Is Memento) Then
        remove(CType(obj, Memento))
      Else
        removeDrawing()
      End If
      undoList.RemoveAt(undoList.Count - 1)  'i usu go
    End If
  End Sub

End Class
