Imports System
Imports System.ComponentModel
Imports System.Drawing
Imports System.Collections
Imports System.Windows.Forms



    Public Class EmplDisp
    Inherits System.Windows.Forms.Form

        'Required by the Win Forms Designer   
        Private components As System.ComponentModel.Container
    Private lbSalary As Label
    Private EmpTree As TreeView
        Dim prez As AbstractEmployee
        Dim rootNode as TreeNode
        dim marketVP As AbstractEmployee
        dim salesMgr As AbstractEmployee
        Dim advMgr As AbstractEmployee
        Dim emp As AbstractEmployee
        Dim prodVP As AbstractEmployee 
        Dim prodMgr As AbstractEmployee
        Dim shipMgr As AbstractEmployee
        private Rnd as Random
    '-------
        Public Sub New()
           MyBase.New
    
           'This call is required by the Win Forms Designer.
           InitializeComponent
    
           Rnd = new Random
           BuildEmployeeList
            buildTree
        End Sub
'-------
        'Clean up any resources being used
        Overrides Public Sub Dispose()
            MyBase.Dispose
            components.Dispose
        End Sub 
'-------
        'The main entry point for the application
        Shared Sub Main()
            System.WinForms.Application.Run(New EmplDisp())
        End Sub
'-------
        'NOTE: The following procedure is required by the Win Forms Designer
        'Do not modify it.
        Private Sub InitializeComponent() 
            Me.components = New System.ComponentModel.Container
            Me.EmpTree = New System.WinForms.TreeView
            Me.lbSalary = New System.WinForms.Label

            EmpTree.Location = New System.Drawing.Point(32, 24)
            EmpTree.Text = "TreeView1"
            EmpTree.Size = New System.Drawing.Size(216, 176)
            EmpTree.TabIndex = 0
            EmpTree.AddOnAfterSelect(New System.WinForms.TreeViewEventHandler(AddressOf Me.treeClick))

            lbSalary.Location = New System.Drawing.Point(64, 232)
            lbSalary.Text = " "
            lbSalary.Size = New System.Drawing.Size(128, 24)
            lbSalary.ForeColor = System.Drawing.SystemColors.ActiveCaption
            lbSalary.Font = New System.Drawing.Font("Microsoft Sans Serif", 14!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.World)
            lbSalary.TabIndex = 1

            Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
            Me.Text = "Employee tree"
            '@design Me.TrayLargeIcon = True
            '@design Me.TrayHeight = 0

            Me.Controls.Add(lbSalary)
            Me.Controls.Add(EmpTree)

        End Sub
'----------        
  Private Sub buildEmployeeList()
  Dim i As Integer

  prez = New Boss("CEO", 200000)

  marketVP = New Boss( "Marketing VP", 100000)
  prez.add (marketVP)

  salesMgr = New Boss("Sales Mgr", 50000)

  advMgr = New Boss("Advt Mgr", 50000)

  marketVP.add( salesMgr)
  marketVP.add (advMgr)
  prodVP = New Boss("Production VP", 100000)

  prez.add (prodVP)
  advMgr.add ("Secy", 20000)

'Dodaj sprzedawcw jako podwadnych menedera dziau sprzeday
  For i = 1 To 5
    salesMgr.add ("Sales" + i.toString, rand_sal(30000))
  Next i

  prodMgr = New Boss("Prod Mgr", 40000)
  shipMgr = New Boss( "Ship Mgr", 35000)
  prodVP.add (prodMgr)
  prodVP.add (shipMgr )

  For i = 1 To 3
    shipMgr.add ("Ship" + i.toString, rand_sal(25000))
  Next i
  For i = 1 To 4
    prodMgr.add ("Manuf" + i.toString, rand_sal(20000))
  Next i
End Sub
'--------
Private sub buildTree()
Dim nod as EmpNode

nod = new EmpNode(prez)
rootNode = nod
EmpTree.nodes.add(nod)
addNodes(nod, prez)
End Sub
'---------
Private Sub treeClick(ByVal sender As System.Object, ByVal e As System.WinForms.TreeViewEventArgs)
  Dim node as EmpNode
  node = CType(EmpTree.SelectedNode, EmpNode)
  getNodeSum(node)
End Sub
'---------
Private Function getNodeSum(node as EmpNode) as Single
Dim emp as AbstractEmployee
Dim sum as Single

emp  = node.getEmployee  
sum = emp.getSalaries

lbSalary.Text = sum.toString
End Function
'---------
Private Function addNodes(nod as EmpNode, emp as AbstractEmployee)
Dim newEmp as AbstractEmployee
Dim newNode as EmpNode
Dim empEnum as IEnumerator
empEnum = emp.getSubordinates

while empEnum.MoveNext
  newEmp = CType(empEnum.Current, AbstractEmployee)
  newNode = new EmpNode(newEmp)
  nod.nodes.Add(newNode)
  addNodes(newNode, newEmp)
End While

End Function
'------------
Private Function rand_sal(sal As Single) As Single
 Dim rnum as Single
 rnum = Rnd.Next
 rnum = rnum/Int32.MaxValue
 return Rnum * sal / 5 + sal
End Function

End Class


