Imports System
Imports System.IO
Imports System.ComponentModel

Public Class vbFile
  'hermetyzuje operacje zapisu, odczytu, sprawdzenia istnienia
  'i usuwania pliku 

  Private opened As Boolean       'True gdy plik jest otwarty
  Private end_file As Boolean     'True gdy koniec pliku
  Private errDesc As String       'Tekst ostatniej informacji o bdzi
  Private File_name As String     'Nazwa pliku
  Private fl As File
  Private ts As StreamReader
  Private tok As StringTokenizer
  Private tokLine As String
  Private fs As FileStream
  Private sw As StreamWriter
  Private errFlag As Boolean
  Private lineLength As Integer
  Private sep As String           'Separator oddzielajcy tokeny
  '-----
  Public Sub New(ByVal filename As String)
    'Tworzy now instancj klasy
    File_name = filename          'Przechowaj nazw pliku
    tokLine = ""                  'Inicjuj tokenizer
    sep = ","                     'Oraz znak separatora
  End Sub
  '----------------
  Public Overloads Function OpenForRead() As Boolean
    Return OpenForRead(File_name)
  End Function
  '----------------
  Public Overloads Function OpenForRead(ByVal Filename As String) As Boolean
    'Otwiera plik o podanej nazwie
    File_name = Filename          'Przechowaj nazw pliku
    errFlag = False               'Kasuj flag bdw
    end_file = False              'Oraz flag koca pliku
    Try
      ts = fl.OpenText(File_name) 'Otwrz plik
    Catch e As Exception
      errDesc = e.Message         'Przechowaj informacj o bdzie
      errFlag = True              'I ustaw flag
    End Try
    Return Not errFlag            'Zwraca False w przypadku gdy operacja si nie powioda
  End Function

  Public Function readLine() As String
    'Wczytuje jeden wiersz pliku
    Dim s As String
    Try
      s = ts.ReadLine             'Wczytaj wiersz z pliku
      lineLength = s.Length       'Wywoaj aby spowodowa wystpienie wyjtku
    Catch e As Exception
      end_file = True             'Ustaw flag koca pliku
      s = ""                      'I zwr pusty cig znakw
    End Try
    Return s
  End Function

  'Alternatywne rozwizanie problemu sprawdzania koca pliku
  Public Function readLineE() As String
    'Wczytuje jeden wiersz pliku
    Dim s As String
    If ts.Peek >= 0 Then          'Sprawd "do przodu"
      s = ts.ReadLine             'Wczytaj jeli istniej jeszcze jakie znaki
      Return s
    Else
      end_file = True             'W przeciwnym razie ustaw flag koca pliku
      Return ""
    End If
  End Function

  Public Function readToken() As String
    If (tokLine = "") Then
      tokLine = ts.ReadLine
    End If
    tok = New StringTokenizer(tokLine, sep)
    tokLine = tok.nextToken
    readToken = tokLine
  End Function

  Public Sub closeFile()
    Try
      ts.Close()
    Catch e As Exception
    End Try

    Try
      sw.Close()
    Catch e As Exception
    End Try


  End Sub

  Public Function exists() As Boolean
    exists = File.Exists(File_name)
  End Function

  Public Function getLastError() As String
    getLastError = errDesc
  End Function

  Public Overloads Function OpenForWrite(ByVal fname As String) As Boolean
    errFlag = False
    Try
      File_name = fname
      sw = File.CreateText(File_name) 'Pobierz obiekt klasy StreamWriter
    Catch e As Exception
      errDesc = e.Message
      errFlag = True
    End Try
    OpenForWrite = Not errFlag
  End Function
  '-------------
  Public Overloads Function OpenForWrite() As Boolean
    OpenForWrite = OpenForWrite(File_name)
  End Function
  '-------------
  Public Sub writeText(ByVal s As String)
    sw.WriteLine(s)               'Zapisz acuch do strumienia
  End Sub

  Public Sub setFilename(ByVal fname As String)
    File_name = fname
  End Sub

  Public Function getFilename() As String
    getFilename = File_name
  End Function

  Public Function fEOF() As Boolean
    fEOF = end_file
  End Function

End Class


