Imports System.Drawing
Imports System.Math

Public Class IsocelesTriangle
  Inherits Triangle
  Private newc As Point
  Private newcx, newcy As Integer
  '-----    
  Public Sub New(ByVal a As Point, ByVal b As Point, ByVal c As Point)
    MyBase.New(a, b, c)
    Dim dx1, dy1, dx2, dy2, side1, side2 As Single
    Dim slope, intercept As Single
    Dim incr As Integer
    dx1 = b.X - a.X
    dy1 = b.Y - a.Y
    dx2 = c.X - b.X
    dy2 = c.Y - b.Y

    side1 = calcSide(dx1, dy1)
    side2 = calcSide(dx2, dy2)

    If (side2 < side1) Then
      incr = -1
    Else
      incr = 1
    End If
    slope = dy2 / dx2
    intercept = c.Y - slope * c.X

    'Wylicz wsprzdne punktu c tak, by uzyska trjkt rwnoramienny
    newcx = c.X
    newcy = c.Y
    While (Abs(side1 - side2) > 1)
      newcx = newcx + incr    'Zwikszaj o jeden punkt
      newcy = (slope * newcx + intercept)
      dx2 = newcx - b.X
      dy2 = newcy - b.Y
      side2 = calcSide(dx2, dy2)
    End While
    newc = New Point(newcx, newcy)
  End Sub
  '------
  Private Function calcSide(ByVal dx As Single, ByVal dy As Single) As Single
    Return Sqrt(dx * dx + dy * dy)
  End Function
  '-----
  'Narysuj linie wykorzystujc zapamitane wsprzdne punktu
  Public Overrides Function draw2ndLine( _
      ByVal g As Graphics, ByVal b As Point, _
          ByVal c As Point) As Point
    g.DrawLine(bpen, b.X, b.Y, newc.X, newc.Y)
    Return newc
  End Function
End Class
