Imports System.Drawing

Public Class VisRectangle
  Implements Drawing
  Protected x, y, w, h As Integer
  Private rect As vbPatterns.Rectangle
  Protected selected As Boolean
  Protected filled As Boolean
  Protected bBrush As SolidBrush
  Protected rBrush As SolidBrush
  Protected bPen As Pen
  Private fillColor As Color
  '-----
  Public Sub New(ByVal xp As Integer, ByVal yp As Integer)
    x = xp                        'ustal pozycj
    y = yp
    w = 40                        'domylny rozmiar
    h = 30
    fillColor = Color.Red
    bBrush = New SolidBrush(Color.Black)
    rBrush = New SolidBrush(fillColor)
    bPen = New Pen(Color.Black)
    saveAsRect()                  'zachowaj klas prostokta
  End Sub
  '------
  Protected Sub saveAsRect()
    rect = New vbPatterns.Rectangle(x, y, w, h)
  End Sub
  '-----
  Public Function contains(ByVal xp As Integer, _
      ByVal yp As Integer) As Boolean Implements Drawing.contains
    Return rect.contains(xp, yp)
  End Function
  '-----
  Public Overridable Sub draw(ByVal g As Graphics) _
      Implements Drawing.draw
    'draw rectangle
    If filled Then
      g.FillRectangle(rBrush, x, y, w, h)
    End If
    g.DrawRectangle(bPen, x, y, w, h)
    If selected Then   'draw handles
      drawHandles(g)
    End If
  End Sub
  '-----
  Protected Sub drawHandles(ByVal g As Graphics)
    g.FillRectangle(bBrush, (x + w \ 2), (y - 2), 4, 4)
    g.FillRectangle(bBrush, x - 2, y + h \ 2, 4, 4)
    g.FillRectangle(bBrush, x + (w \ 2), y + h - 2, 4, 4)
    g.FillRectangle(bBrush, x + (w - 2), y + (h \ 2), 4, 4)
  End Sub
  '-----
  Friend Property rects() As vbPatterns.Rectangle _
      Implements Drawing.rects
    Set(ByVal Value As vbPatterns.Rectangle)
      x = Value.x
      y = Value.y
      w = Value.w
      h = Value.h
      saveAsRect()
    End Set
    Get
      Return rect
    End Get
  End Property
  '-----
  Public Sub setFill(ByVal b As Boolean) _
      Implements Drawing.setFill
    filled = b
  End Sub
  '-----
  Public Overridable Sub move(ByVal xpt As Integer, ByVal ypt As Integer) Implements vbState.Drawing.move
    x = xpt
    y = ypt
    saveAsRect()
  End Sub
  '-----
  Public Sub setSelected(ByVal b As Boolean) Implements vbState.Drawing.setSelected
    selected = b
  End Sub

End Class
