VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Mediator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Klasa Mediator
Private startRect As Boolean
Private selectedIndex As Integer
Private rectb As RectButton
Private dSelected As Boolean
Private drawings As Collection
Private undoList As Collection
Private rbutton As RectButton
Private filbutton As FillButton
Private circButton As CircleButton
Private arrowButton As PickButton
Private canvas As PictureBox
Private selectedDrawing As Integer
Private stmgr As StateManager
'-----
 Public Sub init(Pic As PictureBox)
   startRect = False
   dSelected = False
   Set drawings = New Collection
   Set undoList = New Collection
   Set stmgr = New StateManager
   stmgr.init Me
   Set canvas = Pic
End Sub
'-----
Public Sub startRectangle()
   stmgr.setRect
   arrowButton.setSelected (False)
   circButton.setSelected (False)
   filbutton.setSelected (False)
End Sub
'-----
Public Sub startCircle()
   Dim st As State
   stmgr.setCircle
   rectb.setSelected False
   arrowButton.setSelected False
   filbutton.setSelected False
End Sub
'-----
Public Sub startFill()
  Dim m As FillMemento
  stmgr.setFill
  rectb.setSelected (False)
  circButton.setSelected (False)
  arrowButton.setSelected (False)
  If selectedDrawing > 0 Then
    stmgr.selectOne drawings(selectedDrawing), vbRed
    Set m = New FillMemento
    m.init selectedDrawing, Me
    undoList.Add m
  End If
  repaint
End Sub
'-----
Public Sub startArrow()
  stmgr.setArrow
  rectb.setSelected (False)
  circButton.setSelected (False)
  filbutton.setSelected (False)
 End Sub
'-----
Public Function getSelected() As Drawing
  getSelected = selectedDrawing
End Function
'-----
Public Sub fillSelected()
 Dim m As FillMemento
 If (dSelected) Then
   drawings(selectedDrawing).setFill vbRed
   Set m = New FillMemento
   m.init selectedDrawing, Me
   undoList.Add m
 End If
End Sub
'-----
Public Function getDrawings() As Collection
  Set getDrawings = drawings
End Function
'-----
Public Sub addDrawing(d As Drawing)
  drawings.Add d
  Dim intc As New DrawInstance
  intc.init drawings.Count, Me
  undoList.Add intc
End Sub
'-----
Public Sub registerRectButton(rb As RectButton)
  Set rectb = rb
End Sub
'-----
Public Sub registerCircleButton(cb As CircleButton)
  Set circButton = cb
End Sub
'-----
Public Sub registerArrowButton(ab As PickButton)
  Set arrowButton = ab
End Sub
'-----
Public Sub registerFillButton(fb As FillButton)
  Set filbutton = fb
End Sub
'-----
Public Sub registerCanvas(p As PictureBox)
  Set canvas = p
End Sub
'-----
Public Sub mouseDown(ByVal x As Integer, ByVal y As Integer)
  stmgr.mouseDown x, y
  repaint
End Sub
'-----
Public Sub mouseUp(ByVal x As Integer, ByVal y As Integer)
  stmgr.mouseUp x, y
End Sub
'-----
Public Sub unpick()
  dSelected = False
  If (selectedDrawing > 0) Then
    drawings(selectedDrawing).setSelected False
    selectedDrawing = 0
    repaint
  End If
End Sub
'-----
Public Sub rememberPosition()
  Dim m As Memento
  If dSelected Then
    Set m = New DrawMemento
    m.init drawings(selectedDrawing)
    undoList.Add m
  End If
End Sub
'-----
Public Sub setSelected(index As Integer)
  Dim d As Drawing
  dSelected = True
  selectedDrawing = index
  Set d = drawings(index)
  d.setSelected True
  repaint
End Sub
'-----
Public Sub pickRect(x As Integer, y As Integer)
End Sub

Public Sub clear()
  Set drawings = New Collection
  Set undoList = New Collection
  dSelected = False
  selectedDrawing = 0
  repaint
End Sub
'-----
Private Sub repaint()
  canvas.Refresh
End Sub
'-----
Public Sub mouseDrag(ByVal x As Integer, ByVal y As Integer)
  stmgr.mouseDrag x, y
  reDraw canvas
End Sub
'-----
Public Sub reDraw(g As PictureBox)
  Dim i As Integer
  Dim v As Drawing
  canvas.Cls
  For i = 1 To drawings.Count
    Set v = drawings(i)
    v.draw canvas
  Next i
End Sub
'-----
Public Sub undo()
  Dim obj As Object
  Dim drawObj As Object
  Dim m As Memento
  rectb.setSelected (False)
  circButton.setSelected (False)
  arrowButton.setSelected (False)
  
  If (undoList.Count > 0) Then
    'Pobierz ostatni element z listy wycofa
    Set obj = undoList(undoList.Count)
    undoList.Remove undoList.Count   'I usu go
    'Pobierz memento
    Set m = obj
    m.restore                     'I odtwrz poprzedni pozycj
    repaint
  End If
End Sub
'-----
Public Sub removeDrawing(a As Integer)
  drawings.Remove a
End Sub

Public Function getDrawing(a As Integer)
  Set getDrawing = drawings(a)
End Function

Public Function findDrawing(x As Integer, y As Integer) As Integer
  Dim index As Integer, i As Integer, found As Boolean
  Dim d As Drawing
  i = 1
  index = 0
  While i <= drawings.Count And Not found
    Set d = drawings(i)
    If d.contains(x, y) Then
      index = i
      found = True
    End If
    i = i + 1
  Wend
  findDrawing = index
End Function
