Imports System.Windows.Forms
Imports System.Drawing
Imports System.Collections

Public Class Mediator
  Private startRect As Boolean
  Private rectSelected As Boolean
  Private drawings As ArrayList
  Private canvas As PictureBox
  Private selectedIndex As Integer
  Private caretakr As CareTaker
  Private rect As RectButton
  '-----
  Public Sub New(ByVal p As PictureBox)
    startRect = False
    rectSelected = False

    drawings = New ArrayList()
    caretakr = New CareTaker()
    caretakr.init(drawings)
    canvas = p
  End Sub
  '-----
  Public Sub startRectangle()
    startRect = True
  End Sub
  '-----
  Public Sub createRect(ByVal x As Integer, ByVal y As Integer)
    Dim count As Integer
    Dim v As visRectangle
    unpick()                      'Upewnij si, e aden prostokt nie jest wybrany
    If startRect Then             'Jeli przycisk Rect jest wcinity
      count = drawings.Count
      caretakr.add(count)         'Zapamitaj rozmiar listy rysunkw
      v = New visRectangle(x, y)  'Utwrz prostokt
      drawings.Add(v)             'Dodaj go do listy
      startRect = False           'Narysowano prostokt
      rect.setSelected(False)     'Przywr stan przycisku
      canvas.Refresh()
    Else
      pickRect(x, y)              'W przeciwnym razie przejd do trybu wyboru
    End If
  End Sub
  '------------------------------------------
  Public Sub registerRectButton(ByVal rb As RectButton)
    rect = rb
  End Sub
  '-------------------------------------------
  Private Sub unpick()
    If rectSelected And selectedIndex >= 0 And selectedIndex < drawings.Count Then
      Dim vis As visRectangle
      vis = CType(drawings(selectedIndex), visRectangle)
      vis.setSelected(False)
      selectedIndex = -1
      rectSelected = False
      canvas.Refresh()
    End If
  End Sub
  '-----
  Public Sub pickRect(ByVal x As Integer, ByVal y As Integer)
    'Przechowaj wybrany prostokt

    Dim lastPick As Integer = -1
    Dim v As visRectangle
    Dim i As Integer
    If selectedIndex >= 0 Then
      lastPick = selectedIndex
    End If
    unpick()                      'Kasuj wybr
    'Sprawd czy wybrano jaki prostokt
    For i = 0 To drawings.Count - 1
      v = CType(drawings(i), visRectangle)
      If v.contains(x, y) Then    'Kursor myszy wewntrz prostokta?
        selectedIndex = i         'Przechowaj go
        rectSelected = True
        If selectedIndex <> lastPick Then 'Sprawd, czy wybrano inny prostokt
          caretakr.rememberPosition(v)
        End If
        v.setSelected(True)       'Uchwyty
        repaint()                 'Odrysuj
      End If
    Next i
  End Sub
  '-----
  Public Sub clear()
    drawings = New ArrayList()
    caretakr.clear(drawings)
    rectSelected = False
    selectedIndex = 0
    repaint()
  End Sub
  '-----
  Private Sub repaint()
    canvas.Refresh()
  End Sub
  '-----
  Public Sub drag(ByVal x As Integer, ByVal y As Integer)
    Dim v As visRectangle
    If rectSelected Then
      v = CType(drawings(selectedIndex), visRectangle)
      If v.contains(x, y) Then
        v.move(x, y)
        repaint()
      End If
    End If
  End Sub
  '-------------------------------------------
  Public Sub reDraw(ByVal g As Graphics)
    Dim i As Integer
    Dim v As visRectangle

    For i = 0 To drawings.Count - 1
      v = CType(drawings(i), visRectangle)
      v.draw(g)
    Next i
  End Sub
  '-------------------------------------------
  Public Sub undo()
    caretakr.undo()
    repaint()
  End Sub

End Class
