VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Mediator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Klasa Mediator
Private startRect As Boolean
Private rectSelected As Boolean
Private drawings As Collection
Private canvas As PictureBox
Private selectedIndex As Integer
Private caretakr As Caretaker
Private rect As RectButton

Public Sub init()
  startRect = False
  rectSelected = False
  Set drawings = New Collection
  Set caretakr = New Caretaker
  caretakr.init drawings
End Sub

Public Sub startRectangle()
  startRect = True
End Sub

Public Sub createRect(ByVal x As Integer, ByVal y As Integer)
  Dim count As Integer
  Dim v As VisRectangle
  unpick                          'Upewnij si, e aden prostokt nie jest wybrany
  If startRect Then               'Jeli wybrany przycisk Rect
    count = drawings.count
    caretakr.add count            'Zapisz rozmiar listy rysunkw
    Set v = New VisRectangle      'Utwrz prostokt
    v.init x, y
    drawings.add v                'Dodaj go do listy
    startRect = False             'Prostokt ju narysowany
    rect.setSelected False        'Przywr stan przycisku
    canvas.Refresh
  Else
    pickRect x, y                 'Jeli nie, to tryb wyboru
  End If
End Sub
'------------------------------------------
Public Sub registerRectButton(rb As RectButton)
  Set rect = rb
End Sub
'-------------------------------------------
Public Sub registerCanvas(p As PictureBox)
  Set canvas = p
End Sub

Private Sub unpick()
  If rectSelected Then
    drawings(selectedIndex).setSelected False
    selectedIndex = 0
    rectSelected = False
    canvas.Refresh
  End If
End Sub

Public Sub pickRect(x As Integer, y As Integer)
  'Przechowaj wybrany prostokt

  Dim lastPick As Integer
  Dim v As VisRectangle
  Dim i As Integer
  If selectedIndex > 0 Then
    lastPick = selectedIndex
  End If
  unpick  'Deaktywuj wybr
  'Sprawd, czy ktry bdzie wybrany
  For i = 1 To drawings.count
    Set v = drawings(i)
    If v.contains(x, y) Then 'Kursor myszy wewntrz prostokta?
      selectedIndex = i     'Przechowaj go
      rectSelected = True
      If selectedIndex <> lastPick Then 'Sprawd czy to ten sam
        caretakr.rememberPosition drawings(selectedIndex)
      End If
      v.setSelected True   'Narysuj uchwyty
      repaint            'I odwie
    End If
  Next i
End Sub

Public Sub clear()
  Set drawings = New Collection
  caretakr.clear drawings
  rectSelected = False
  selectedIndex = 0
  repaint
End Sub

Private Sub repaint()
  canvas.Refresh
End Sub

Public Sub drag(ByVal x As Integer, ByVal y As Integer)
  If rectSelected Then
    If drawings(selectedIndex).contains(x, y) Then
      drawings(selectedIndex).move x, y
      repaint
    End If
  End If
End Sub
'-------------------------------------------
Public Sub reDraw(g As PictureBox)
  Dim i As Integer
  Dim v As VisRectangle
  g.FillColor = vbBlack
  For i = 1 To drawings.count
    Set v = drawings(i)
    v.draw g
  Next i
End Sub
'-------------------------------------------
Public Sub undo()
  caretakr.undo
  repaint
End Sub
