Imports System
Imports System.ComponentModel
Imports System.Drawing
Imports System.Drawing.Color
Imports System.Windows.Forms
Imports System.Collections

Public Class BlueCommand
  Implements Command

  Private drawList As ArrayList
  Protected colr As Color
  Protected x, y, dx, dy As Integer
  Private pic As PictureBox
  '-----
  Public Sub New(ByVal pict As PictureBox)
    MyBase.New()
    pic = pict
    drawList = New ArrayList()
    x = pic.Width
    colr = Color.Blue
    dx = -20
    y = 0
    dy = 0
  End Sub
  '-----
  Public Sub Execute() Implements Command.Execute
    Dim dl As DrawData
    dl = New DrawData(x, y, dx, dy)
    drawList.Add(dl)
    x = x + dx
    y = y + dy
    pic.Refresh()
  End Sub
  '-----
  Public Function isUndo() As Boolean Implements Command.isUndo
    Return False
  End Function
  '-----
  Public Sub Undo() Implements Command.Undo
    Dim Index As Integer
    Dim dl As DrawData
    Index = drawList.Count - 1
    If Index >= 0 Then
      dl = CType(drawList(Index), DrawData)
      drawList.RemoveAt(Index)
      x = dl.getX
      y = dl.getY
    End If
    pic.Refresh()
  End Sub
  '-----
  Public Sub draw(ByVal g As Graphics)
    Dim h, w As Integer
    Dim i As Integer
    Dim dl As DrawData

    Dim rpen As New Pen(Color.FromArgb(255, colr), 1)
    h = pic.Height
    w = pic.Width

    For i = 0 To drawList.Count - 1
      dl = CType(drawList(i), DrawData)
      g.DrawLine(rpen, dl.getX, dl.getY, dl.getX + dx, dl.getY + h)
    Next i
  End Sub
End Class
