Imports System.Collections
Imports System.Data
Imports System.Data.SqlClient
Imports System.Data.OleDb
Imports System.Windows.Forms

Public Class DBTable
  Private names As Hashtable
  Protected db As DBase
  Protected tableName As String
  Private index As Integer
  Private dtable As DataTable
  Private filled As Boolean
  Private columnName As String
  Private rowIndex As Integer
  Private opened As Boolean
  Dim conn As OleDbConnection
  Dim cmd As OleDbCommand
  Dim dset As DataSet
  Dim row As DataRow

  Public Sub New(ByVal datab As DBase, ByVal tname As String)
    names = New Hashtable()
    db = datab
    tableName = tname
    index = 1
    filled = False
    opened = False
  End Sub
  '-------
  Public Sub createTable()
    Try
      dtable = New DataTable(tableName)
      dtable.Clear()
    Catch e As SqlException
    End Try
  End Sub
  '-------
  Public Function hasMoreElements() As Boolean
    If opened Then
      Return (rowIndex < dtable.Rows.Count)
    Else
      Return False
    End If
  End Function
  '-------
  Public Function getKey(ByVal nm As String, ByVal keyname As String) As Long
    Dim i, key As Integer
    Dim dtable As DataTable
    Dim row As DataRow
    If Not filled Then
      Return CType(names.Item(nm), Integer)
    Else
      Dim query As String
      query = "select * from " & tableName & " where " & columnName & "='" & Replace(nm, "'", "''") & "'"
      dtable = db.openQuery(query)
      row = dtable.Rows(0)
      key = CInt(row(keyname).ToString)
      Return key
    End If
  End Function
  '-------
  Public Function getValue(ByVal columnName As String) As String
    'Zwraca kolejn warto z tabeli 
    'Zakada, e openTable zostaa ju wykonana
    If opened Then
      Dim row As DataRow
      row = dtable.Rows(rowIndex)
      rowIndex = rowIndex + 1
      Return row(columnName).ToString
    Else
      Return ""
    End If
  End Function
  '-------
  Public Sub openTable()
    dtable = db.openTable(tableName)
    rowIndex = 0
    opened = True
  End Sub
  '-----
  Private Sub openConn()
    If conn.State = ConnectionState.Closed Then
      conn.Open()
    End If
  End Sub
  '-----
  Private Sub closeConn()
    If conn.State = ConnectionState.Open Then
      conn.Close()
    End If
  End Sub
  '-----
  Public Overridable Sub addTableValue(ByVal nm As String)
    'Umieszcza nazwy w tablicy z kodowaniem mieszajcym
    Try
      names.Add(nm, index)
      index = index + 1
    Catch e As ArgumentException
      'Nie pozwl by nazwy si duplikoway	
    End Try
  End Sub
  '-------
  Public Overridable Sub makeTable(ByVal colName As String)
    'Umieszcza wartoci z tablicy z kodowaniem mieszajcym
    'W tabeli bazy danych
    dset = New DataSet(tableName)       'Utwrz Dataset
    columnName = colName
    Dim name As String
    dtable = New DataTable(tableName)   'Oraz tabel
    dset.Tables.Add(dtable)             'Dodaj do kolekcji
    conn = db.getConnection
    openConn()                          'Otwrz poczenie
    Dim adcmd As New OleDbDataAdapter()
    'Uzyskaj dostp do tabeli
    adcmd.SelectCommand = _
        New OleDbCommand("Select * from " & tableName, conn)
    Dim olecb As New OleDbCommandBuilder(adcmd)
    adcmd.TableMappings.Add("Table", tableName)
    'Zaaduj dane do lokalnej kopii tabeli
    adcmd.Fill(dset, tableName)
    'Pobierz Enumerator dla Hashtable
    Dim ienum As IEnumerator = names.Keys.GetEnumerator
    'Przemieszczaj si w tabeli dodajc nowe nazwy w wierszach
    While ienum.MoveNext
      name = CType(ienum.Current, String)
      row = dtable.NewRow
      row(colName) = name
      dtable.Rows.Add(row)
    End While
    'Dodaj tabel do bazy danych
    Try
      adcmd.Update(dset)
      closeConn()
      filled = True
    Catch e As Exception
      MessageBox.Show(e.Message)
    End Try
  End Sub
  '------
  Public Sub delete()
    'Usuwa tabel
    conn = db.getConnection
    openConn()
    Dim adcmd As New OleDbCommand("Delete * from " & tableName, conn)
    Try
      adcmd.ExecuteNonQuery()
      closeConn()
    Catch e As Exception
      MessageBox.Show(e.Message)
    End Try
  End Sub
End Class
