Public Class CompDemo
  Inherits System.Windows.Forms.Form
  Dim prez As AbstractEmployee
  Dim rootNode As TreeNode
  Dim marketVP As AbstractEmployee
  Dim salesMgr As AbstractEmployee
  Dim advMgr As AbstractEmployee
  Dim emp As AbstractEmployee
  Dim prodVP As AbstractEmployee
  Dim prodMgr As AbstractEmployee
  Dim shipMgr As AbstractEmployee
  Friend WithEvents lbSalary As System.Windows.Forms.Label
  Friend WithEvents EmpTree As System.Windows.Forms.TreeView
  Private Rnd As Random
  Private Sub init()
    Rnd = New Random()
    buildEmployeeList()
    buildTree()
  End Sub
#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call
    init()
  End Sub
  Private Sub buildEmployeeList()
    Dim i As Integer

    prez = New Boss("CEO", 200000)

    marketVP = New Boss("Marketing VP", 100000)
    prez.add(marketVP)

    salesMgr = New Boss("Sales Mgr", 50000)

    advMgr = New Boss("Advt Mgr", 50000)

    marketVP.add(salesMgr)
    marketVP.add(advMgr)
    prodVP = New Boss("Production VP", 100000)

    prez.add(prodVP)
    advMgr.add("Secy", 20000)

    'add salesmen reporting to sales manager
    For i = 1 To 5
      salesMgr.add("Sales" + i.ToString, rand_sal(30000))
    Next i

    prodMgr = New Boss("Prod Mgr", 40000)
    shipMgr = New Boss("Ship Mgr", 35000)
    prodVP.add(prodMgr)
    prodVP.add(shipMgr)

    For i = 1 To 3
      shipMgr.add("Ship" + i.ToString, rand_sal(25000))
    Next i
    For i = 1 To 4
      prodMgr.add("Manuf" + i.ToString, rand_sal(20000))
    Next i
  End Sub
  '--------
  Private Sub buildTree()
    Dim nod As EmpNode

    nod = New EmpNode(prez)
    rootNode = nod
    EmpTree.Nodes.Add(nod)
    addNodes(nod, prez)
  End Sub
  '---------
  Private Function getNodeSum(ByVal node As EmpNode) As Single
    Dim emp As AbstractEmployee
    Dim sum As Single

    emp = node.getEmployee
    sum = emp.getSalaries

    'lbSalary.Text = sum.Format("n", Nothing)
    lbSalary.Text = Format(sum, "n")
  End Function
  '---------
  Private Sub addNodes(ByVal nod As EmpNode, ByVal emp As AbstractEmployee)
    Dim newEmp As AbstractEmployee
    Dim newNode As EmpNode
    Dim empEnum As IEnumerator
    empEnum = emp.getSubordinates

    While empEnum.MoveNext
      newEmp = CType(empEnum.Current, AbstractEmployee)
      newNode = New EmpNode(newEmp)
      nod.Nodes.Add(newNode)
      addNodes(newNode, newEmp)
    End While

  End Sub
  '------------
  Private Function rand_sal(ByVal sal As Single) As Single
    Dim rnum As Single
    rnum = Rnd.Next
    rnum = rnum / Int32.MaxValue
    Return rnum * sal / 5 + sal
  End Function


  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.EmpTree = New System.Windows.Forms.TreeView()
    Me.lbSalary = New System.Windows.Forms.Label()
    Me.SuspendLayout()
    '
    'EmpTree
    '
    Me.EmpTree.ImageIndex = -1
    Me.EmpTree.Location = New System.Drawing.Point(32, 16)
    Me.EmpTree.Name = "EmpTree"
    Me.EmpTree.SelectedImageIndex = -1
    Me.EmpTree.Size = New System.Drawing.Size(216, 208)
    Me.EmpTree.TabIndex = 0
    '
    'lbSalary
    '
    Me.lbSalary.Font = New System.Drawing.Font("Microsoft Sans Serif", 12.0!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.lbSalary.Location = New System.Drawing.Point(48, 240)
    Me.lbSalary.Name = "lbSalary"
    Me.lbSalary.Size = New System.Drawing.Size(176, 24)
    Me.lbSalary.TabIndex = 1
    '
    'CompDemo
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(288, 273)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lbSalary, Me.EmpTree})
    Me.Name = "CompDemo"
    Me.Text = "Composite"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub EmpTree_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles EmpTree.AfterSelect
    Dim node As EmpNode
    node = CType(EmpTree.SelectedNode, EmpNode)
    getNodeSum(node)

  End Sub
End Class
