Imports System
Imports System.ComponentModel
Imports Microsoft.VisualBasic

Public Class Times
  Dim t As Single
  Dim errflag As Boolean
  Private Const tmNT As Single = 10000
  Private Const tmDQ As Single = 20000
  Private Const tmSCRATCH As Single = 30000

  'Klasa uywana jest do odczytu i formatowania uzyskanych czasw
  'i zawiera rwnie deklaracj staych

  Public Sub New(ByVal Stime As String)
    setText(Stime)
  End Sub

  Public ReadOnly Property NT() As Single
    Get
      Return tmNT
    End Get
  End Property

  Public ReadOnly Property SCRATCH() As Single
    Get
      Return tmSCRATCH
    End Get
  End Property

  Public Sub setSingle(ByVal tv As Single)
    t = tv
  End Sub

  Public Function getSingle() As Single
    Return t
  End Function

  Public Function getWFormatted(ByVal width As Integer) As String
    Dim s As String
    Dim w As Integer
    s = getFormatted()
    w = width - Len(s$)
    If w > 0 Then
      s = Space$(w) + s
    End If
    getWFormatted = s
  End Function

  Public Function getFormatted() As String
    Dim mins As Integer
    Dim secs As Single
    Dim s As String

    If t >= 100 And t < 3000 Then
      mins = (t / 100)
      secs = t - mins * 100.0F
    Else
      secs = t
    End If
    If mins > 0 Then
      s$ = Trim$(Str$(mins)) + ":" + Format$(secs, "00.00")
      getFormatted = s$
    Else
      getFormatted = Format$(secs, "##.00")
    End If
    If t = tmNT Or t = 0 Then
      getFormatted = "NT"
    End If
    If t = tmDQ Then
      getFormatted = "DQ"
    End If
    If t = tmSCRATCH Then
      getFormatted = "SCR"
    End If
  End Function

  Public Function setText(ByVal tx As String) As Boolean
    Dim i, mins As Integer
    Dim secs As Single
    errflag = False

    Dim nfi As NumberFormatInfo
    nfi = New NumberFormatInfo()
    nfi.NumberDecimalSeparator = "."

    tx = Trim$(tx)
    i = tx.IndexOf(":")
    If i > 0 Then
      mins = Convert.ToInt16(tx.Substring(0, i))
      secs = Single.Parse(tx.Substring(i + 1), nfi)
      If secs > 59.99 Then
        errflag = True
      End If
      t = mins * 100 + secs
    Else
      mins = (Single.Parse(tx, nfi) / 100)
      secs = Single.Parse(tx, nfi) - (100 * mins)
      If secs > 59.99 Then
        errflag = True
        t = NT
      Else
        t = Single.Parse(tx, nfi)
      End If
    End If
    If Left$((UCase$(tx)), 1) = "S" Then
      t = tmSCRATCH
    End If
    If UCase$(tx) = "NT" Or UCase(tx) = "N.T." Then
      t = NT
    End If
    setText = Not errflag        'zwraca True jeli OK, False jeli bd
  End Function

  Public Function getSeconds(ByVal t As Single) As Single
    Dim mins As Integer
    Dim secs As Single

    mins = Convert.ToInt16(t / 100)
    secs = t - mins * 100
    getSeconds = mins * 60 + secs
  End Function

  Public Sub setSeconds(ByVal s As Single)
    Dim mins As Integer
    Dim secs As Single

    mins = Convert.ToInt16(s / 60)
    secs = s - mins * 60
    t = mins * 100 + secs
  End Sub

  Public Function getMinutes(ByVal t As Single) As Single
    Dim mins As Integer
    Dim secs As Single
    mins = Convert.ToInt16(t / 60)
    secs = t - mins * 60
    getMinutes = mins * 100 + secs
  End Function

End Class
