Option Strict Off
Option Explicit On
Friend Class Form1
	Inherits System.Windows.Forms.Form

#Region "Windows Form Designer generated code "
  Public Sub New()
    MyBase.New()
    If m_vb6FormDefInstance Is Nothing Then
      If m_InitializingDefInstance Then
        m_vb6FormDefInstance = Me
      Else
        Try
          'For the start-up form, the first instance created is the default instance.
          If System.Reflection.Assembly.GetExecutingAssembly.EntryPoint.DeclaringType Is Me.GetType Then
            m_vb6FormDefInstance = Me
          End If
        Catch
        End Try
      End If
    End If
    'This call is required by the Windows Form Designer.
    InitializeComponent()
  End Sub
  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
    If Disposing Then
      If Not components Is Nothing Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(Disposing)
  End Sub
  Private components As System.ComponentModel.IContainer
  'Required by the Windows Form Designer
  Public ToolTip1 As System.Windows.Forms.ToolTip
  Public WithEvents Taxable As System.Windows.Forms.Button
  Public WithEvents txAmt As System.Windows.Forms.TextBox
  Public WithEvents btCompute As System.Windows.Forms.Button
  Public WithEvents txDate As System.Windows.Forms.TextBox
  Public WithEvents lsOwn As System.Windows.Forms.ListBox
  Public WithEvents Buy As System.Windows.Forms.Button
  Public WithEvents lsStocks As System.Windows.Forms.ListBox
  Public WithEvents Label5 As System.Windows.Forms.Label
  Public WithEvents Label4 As System.Windows.Forms.Label
  Public WithEvents Label3 As System.Windows.Forms.Label
  Public WithEvents Label2 As System.Windows.Forms.Label
  Public WithEvents lbFunds As System.Windows.Forms.Label
  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.components = New System.ComponentModel.Container()
    Me.Label3 = New System.Windows.Forms.Label()
    Me.lsOwn = New System.Windows.Forms.ListBox()
    Me.Taxable = New System.Windows.Forms.Button()
    Me.Buy = New System.Windows.Forms.Button()
    Me.txDate = New System.Windows.Forms.TextBox()
    Me.lbFunds = New System.Windows.Forms.Label()
    Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
    Me.btCompute = New System.Windows.Forms.Button()
    Me.txAmt = New System.Windows.Forms.TextBox()
    Me.Label4 = New System.Windows.Forms.Label()
    Me.Label5 = New System.Windows.Forms.Label()
    Me.lsStocks = New System.Windows.Forms.ListBox()
    Me.Label2 = New System.Windows.Forms.Label()
    Me.SuspendLayout()
    '
    'Label3
    '
    Me.Label3.BackColor = System.Drawing.SystemColors.Control
    Me.Label3.Cursor = System.Windows.Forms.Cursors.Default
    Me.Label3.ForeColor = System.Drawing.SystemColors.ControlText
    Me.Label3.Location = New System.Drawing.Point(144, 0)
    Me.Label3.Name = "Label3"
    Me.Label3.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Label3.Size = New System.Drawing.Size(96, 16)
    Me.Label3.TabIndex = 8
    Me.Label3.Text = "Funds remaining"
    '
    'lsOwn
    '
    Me.lsOwn.BackColor = System.Drawing.SystemColors.Window
    Me.lsOwn.Cursor = System.Windows.Forms.Cursors.Default
    Me.lsOwn.ForeColor = System.Drawing.SystemColors.WindowText
    Me.lsOwn.Location = New System.Drawing.Point(240, 32)
    Me.lsOwn.Name = "lsOwn"
    Me.lsOwn.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.lsOwn.Size = New System.Drawing.Size(185, 147)
    Me.lsOwn.TabIndex = 2
    '
    'Taxable
    '
    Me.Taxable.BackColor = System.Drawing.SystemColors.Control
    Me.Taxable.Cursor = System.Windows.Forms.Cursors.Default
    Me.Taxable.Location = New System.Drawing.Point(272, 240)
    Me.Taxable.Name = "Taxable"
    Me.Taxable.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Taxable.Size = New System.Drawing.Size(137, 25)
    Me.Taxable.TabIndex = 11
    Me.Taxable.Text = "Taxable income on date"
    '
    'Buy
    '
    Me.Buy.BackColor = System.Drawing.SystemColors.Control
    Me.Buy.Cursor = System.Windows.Forms.Cursors.Default
    Me.Buy.Enabled = False
    Me.Buy.Location = New System.Drawing.Point(144, 144)
    Me.Buy.Name = "Buy"
    Me.Buy.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Buy.Size = New System.Drawing.Size(73, 33)
    Me.Buy.TabIndex = 1
    Me.Buy.Text = "Buy >>"
    '
    'txDate
    '
    Me.txDate.AcceptsReturn = True
    Me.txDate.AutoSize = False
    Me.txDate.BackColor = System.Drawing.SystemColors.Window
    Me.txDate.Cursor = System.Windows.Forms.Cursors.IBeam
    Me.txDate.ForeColor = System.Drawing.SystemColors.WindowText
    Me.txDate.Location = New System.Drawing.Point(288, 216)
    Me.txDate.MaxLength = 0
    Me.txDate.Name = "txDate"
    Me.txDate.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.txDate.Size = New System.Drawing.Size(105, 19)
    Me.txDate.TabIndex = 4
    Me.txDate.Text = "Text1"
    '
    'lbFunds
    '
    Me.lbFunds.BackColor = System.Drawing.Color.White
    Me.lbFunds.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.lbFunds.Cursor = System.Windows.Forms.Cursors.Default
    Me.lbFunds.ForeColor = System.Drawing.SystemColors.ControlText
    Me.lbFunds.Location = New System.Drawing.Point(144, 24)
    Me.lbFunds.Name = "lbFunds"
    Me.lbFunds.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.lbFunds.Size = New System.Drawing.Size(81, 25)
    Me.lbFunds.TabIndex = 3
    Me.lbFunds.Text = "Label1"
    '
    'btCompute
    '
    Me.btCompute.BackColor = System.Drawing.SystemColors.Control
    Me.btCompute.Cursor = System.Windows.Forms.Cursors.Default
    Me.btCompute.Location = New System.Drawing.Point(264, 184)
    Me.btCompute.Name = "btCompute"
    Me.btCompute.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.btCompute.Size = New System.Drawing.Size(145, 25)
    Me.btCompute.TabIndex = 5
    Me.btCompute.Text = "Compute values on date"
    '
    'txAmt
    '
    Me.txAmt.AcceptsReturn = True
    Me.txAmt.AutoSize = False
    Me.txAmt.BackColor = System.Drawing.SystemColors.Window
    Me.txAmt.Cursor = System.Windows.Forms.Cursors.IBeam
    Me.txAmt.ForeColor = System.Drawing.SystemColors.WindowText
    Me.txAmt.Location = New System.Drawing.Point(144, 96)
    Me.txAmt.MaxLength = 0
    Me.txAmt.Name = "txAmt"
    Me.txAmt.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.txAmt.Size = New System.Drawing.Size(73, 25)
    Me.txAmt.TabIndex = 6
    Me.txAmt.Text = "1000"
    '
    'Label4
    '
    Me.Label4.BackColor = System.Drawing.SystemColors.Control
    Me.Label4.Cursor = System.Windows.Forms.Cursors.Default
    Me.Label4.ForeColor = System.Drawing.SystemColors.ControlText
    Me.Label4.Location = New System.Drawing.Point(136, 72)
    Me.Label4.Name = "Label4"
    Me.Label4.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Label4.Size = New System.Drawing.Size(89, 17)
    Me.Label4.TabIndex = 9
    Me.Label4.Text = "Amount to invest"
    '
    'Label5
    '
    Me.Label5.BackColor = System.Drawing.SystemColors.Control
    Me.Label5.Cursor = System.Windows.Forms.Cursors.Default
    Me.Label5.ForeColor = System.Drawing.SystemColors.ControlText
    Me.Label5.Location = New System.Drawing.Point(264, 8)
    Me.Label5.Name = "Label5"
    Me.Label5.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Label5.Size = New System.Drawing.Size(121, 17)
    Me.Label5.TabIndex = 10
    Me.Label5.Text = "Stocks you own"
    '
    'lsStocks
    '
    Me.lsStocks.BackColor = System.Drawing.SystemColors.Window
    Me.lsStocks.Cursor = System.Windows.Forms.Cursors.Default
    Me.lsStocks.ForeColor = System.Drawing.SystemColors.WindowText
    Me.lsStocks.Location = New System.Drawing.Point(16, 32)
    Me.lsStocks.Name = "lsStocks"
    Me.lsStocks.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.lsStocks.Size = New System.Drawing.Size(113, 147)
    Me.lsStocks.TabIndex = 0
    '
    'Label2
    '
    Me.Label2.BackColor = System.Drawing.SystemColors.Control
    Me.Label2.Cursor = System.Windows.Forms.Cursors.Default
    Me.Label2.ForeColor = System.Drawing.SystemColors.ControlText
    Me.Label2.Location = New System.Drawing.Point(16, 8)
    Me.Label2.Name = "Label2"
    Me.Label2.RightToLeft = System.Windows.Forms.RightToLeft.No
    Me.Label2.Size = New System.Drawing.Size(89, 17)
    Me.Label2.TabIndex = 7
    Me.Label2.Text = "Available stocks"
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(437, 269)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Taxable, Me.txAmt, Me.btCompute, Me.txDate, Me.lsOwn, Me.Buy, Me.lsStocks, Me.Label5, Me.Label4, Me.Label3, Me.Label2, Me.lbFunds})
    Me.Location = New System.Drawing.Point(4, 23)
    Me.Name = "Form1"
    Me.Text = "Investment simulator"
    Me.ResumeLayout(False)

  End Sub
#End Region

#Region "Upgrade Support "
  Private Shared m_vb6FormDefInstance As Form1
  Private Shared m_InitializingDefInstance As Boolean
  Public Shared Property DefInstance() As Form1
    Get
      If m_vb6FormDefInstance Is Nothing OrElse m_vb6FormDefInstance.IsDisposed Then
        m_InitializingDefInstance = True
        m_vb6FormDefInstance = New Form1()
        m_InitializingDefInstance = False
      End If
      DefInstance = m_vb6FormDefInstance
    End Get
    Set(ByVal Value As Form1)
      m_vb6FormDefInstance = Value
    End Set
  End Property
#End Region

  Private amtLeft As Single
  Private stocks As Collection = New Collection()
  Private stocksOwned As Collection = New Collection()
  Private stk As Stock

  Private Sub btCompute_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles btCompute.Click
    Dim i As Short
    Dim dt As Date
    lsOwn.Items.Clear()
    dt = CDate(txDate.Text)
    For i = 1 To stocksOwned.Count()
      stk = stocksOwned.Item(i)
      lsOwn.Items.Add(stk.getName & ControlChars.Tab & VB6.Format(stk.getValue(dt), "####.00"))
    Next i
  End Sub

  Private Sub Buy_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Buy.Click
    Dim i As Short
    Dim money As Single

    i = lsStocks.SelectedIndex
    If i >= 0 Then
      stk = stocks.Item(i + 1)
      money = Val(Replace(txAmt.Text, ",", "."))
      If money > 0 Then
        stk.invest(money)
        stocksOwned.Add(stk)
        lsOwn.Items.Add(stk.getName)
        lsStocks.Items.RemoveAt(i)
        stocks.Remove(i + 1)
        amtLeft = amtLeft - money
        lbFunds.Text = Str(amtLeft)
      End If
    End If
  End Sub

  Private Sub Form1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
    Dim i As Short
    Dim sname As String

    amtLeft = 10000
    lbFunds.Text = Str(amtLeft)
    txDate.Text = CStr(System.DateTime.FromOADate(CDate(DateString).ToOADate + 1))

    'Utwrz list akcji
    stk = New Stock()
    stk.init("Apple", False)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("Boston", True)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("Cisco", False)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("Dedham", True)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("Electro", False)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("Fedex", False)
    stocks.Add(stk)

    stk = New Stock()
    stk.init("GE", False)
    stocks.Add(stk)

    For i = 1 To stocks.Count()
      stk = stocks.Item(i)
      sname = stk.getName
      If stk.isBond Then
        sname = sname & " *"
      End If
      lsStocks.Items.Add(sname)
    Next i
  End Sub

  Private Sub lsStocks_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles lsStocks.SelectedIndexChanged
    Buy.Enabled = True
  End Sub

  Private Sub Taxable_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Taxable.Click
    Dim i As Short
    Dim dt As Date
    lsOwn.Items.Clear()
    dt = CDate(txDate.Text)
    For i = 1 To stocksOwned.Count()
      stk = stocksOwned.Item(i)
      lsOwn.Items.Add(stk.getName & ControlChars.Tab & VB6.Format(stk.getTaxable(dt), "###0.00"))
    Next i
  End Sub

End Class