Namespace commerce
    '
    ' Classes that provide conversion rates to US Dollars
    ' from other currencies implement this interface.
    '
    Public Interface ICurrencyConversion
        '
        ' Return the conversion factor for the given currency.  You
        ' multiply an amount in the given currency by the number returned
        ' by this method to get an equivalent amount in U.S. Dollars.
        '
        ' Parameters:
        ' - currency
        '   A three letter ISO 4217 currency abbreviation.
        '
        ' - time
        '   The effective time of the requested conversion factor.  This 
        ' allows for queries about historical rates or forcasted rates.
        '
        Function ConverstionToUSDollars(ByVal currency As String, _
                                        ByVal time As DateTime) As Decimal
    End Interface
End Namespace

