﻿Imports Commerce.commerce

Module Module1
    Private unitFactory As UnitAmountFactory _
        = UnitAmountFactory.getInstance()
    Private moneyFactory As MonetaryAmountFactory _
        = MonetaryAmountFactory.getInstance()
    Private weightFactory As WeightAmountFactory _
            = WeightAmountFactory.getInstance()

    Sub Main()
        Dim items As SaleItem() = CreateSaleItems()
        Dim totalWeight As IQuantity _
            = weightFactory.CreateWeight(0, Weight.Ounce)
        For i As Integer = 0 To items.Length - 1
            PrintSaleItem(items(i))
            totalWeight = totalWeight.add(items(i).Weight.multiply(items(i).Qty.Amount))
        Next i
        Console.Write("Total weight = ")
        Console.WriteLine(totalWeight)
        Console.Write("Total weight = ")
        Console.WriteLine(weightFactory.ConvertWeight(totalWeight, Weight.Pound))

        Console.ReadLine()
    End Sub

    Private Sub PrintSaleItem(ByVal item As SaleItem)
        Console.Write(item.Qty)
        Console.Write(" * ")
        Console.Write(item.ItemDescription)
        Console.Write(" @ ")
        Console.Write(item.UnitPrice)
        Console.Write(" = ")
        Dim eaches As IQuantity _
            = unitFactory.ConvertUnit(item.Qty, Unit.Eaches)
        Console.Write(item.UnitPrice.multiply(eaches.Amount))
        Console.Write("       ")
        Console.Write(item.Qty)
        Console.Write(" * ")
        Console.Write(item.Weight)
        Console.Write(" = ")
        Console.WriteLine(item.Weight.multiply(eaches.Amount))
    End Sub

    Private Function CreateSaleItems() As SaleItem()
        Dim items(3) As SaleItem

        items(0).Qty = unitFactory.CreateUnit(5, Unit.Eaches)
        items(0).ItemDescription = "Small Widgets"
        items(0).UnitPrice _
            = moneyFactory.CreateMoney(3.57D, _
                                       Currency.USDollar)
        items(0).Weight _
            = weightFactory.CreateWeight(5D, Weight.Ounce)

        items(1).Qty = unitFactory.CreateUnit(6, Unit.Eaches)
        items(1).ItemDescription = "Medium Widgets"
        items(1).UnitPrice _
                = moneyFactory.CreateMoney(4.82D, _
                                           Currency.USDollar)
        items(1).Weight _
                = weightFactory.CreateWeight(8D, Weight.Ounce)

        items(2).Qty = unitFactory.CreateUnit(3, Unit.Eaches)
        items(2).ItemDescription = "Large Widgets"
        items(2).UnitPrice _
            = moneyFactory.CreateMoney(8.03D, _
                                       Currency.USDollar)
        items(2).Weight _
            = weightFactory.CreateWeight(18D, Weight.Ounce)

        items(3).Qty = unitFactory.CreateUnit(2, Unit.Eaches)
        items(3).ItemDescription = "Jumbo Widgets"
        items(3).UnitPrice() _
            = moneyFactory.CreateMoney(29.39D, _
                                    Currency.USDollar)
        items(3).Weight() _
            = weightFactory.CreateWeight(31D, Weight.Ounce)
        Return items
    End Function

    ' Struct to use in place of real sale item objects.
    Private Structure SaleItem
        Private myQty As IQuantity
        Private myItemDescription As String
        Private myWeight As IQuantity
        Private myUnitPrice As IQuantity

        Public Property Qty() As IQuantity
            Get
                Return myQty
            End Get
            Set(ByVal Value As IQuantity)
                myQty = Value
            End Set
        End Property

        Public Property ItemDescription() As String
            Get
                Return myItemDescription
            End Get
            Set(ByVal Value As String)
                myItemDescription = Value
            End Set
        End Property

        Public Property UnitPrice() As IQuantity
            Get
                Return myUnitPrice
            End Get
            Set(ByVal Value As IQuantity)
                myUnitPrice = Value
            End Set
        End Property

        Public Property Weight() As IQuantity
            Get
                Return myWeight
            End Get
            Set(ByVal Value As IQuantity)
                myWeight = Value
            End Set
        End Property
    End Structure
End Module
